
#include "nvddemo.h"

#include "DecCtrlClient.h"//------test
#include "DecCtrlClientTypes.h"
#include "RetValue.h"

#define MAX_PUSH_STREAM_LEN 1024*512

const int MAX_CMD = 512;
const int MAX_DECNUM = 1024;
const int MAX_NVSNUM = 128;
const unsigned int START_MSG = 90000;
CLS_NVDSDKHelper* pClsNVD = NULL;
map<string ,int> g_mpCmd;
string        g_strCurIP;
bool g_bIsSDKStart = false;
bool g_bSleep = false;
pNVSINFO *g_pNvsArr = NULL;
pGetControlCode GetControlCode = NULL;
pReleaseCtrl    ReleaseCtrl = NULL;
FILE *pFile = NULL;
bool g_bLogin = false;
vector<st_Decoder>  m_VecDecoder(20);
//FILE *pFile_Ex = NULL;

//¼NVS
int g_NVSNum = 0;
bool g_bStopSendThread = false;	//ݵ߳

int CalculateVideoSize(S_header* _pfileHeader);

//////////////////////////////////////////////////////////////////////////
//ָָͨ߳

int gets_s(char *_pcStr, int _iCount)
{
    if (_pcStr == NULL)
        return -1;

	char* pcRet = fgets(_pcStr, _iCount, stdin);
    size_t uiLen = strlen(_pcStr);
    if (pcRet == NULL || uiLen == 0)
        return -2;

    if (_iCount - 1 > (int)uiLen || _pcStr[uiLen-1] == '\n')
    {
        _pcStr[uiLen-1] = '\0';
    }
#ifndef __APPLE__
    stdin->_IO_read_ptr = stdin->_IO_read_end;
#endif
    //tcflush( STDIN_FILENO, TCIFLUSH );
	return 0;
}

int to_int_def(const char* _pstrFrom, int _iDef)
{
	if(NULL == _pstrFrom)
	{
		return _iDef;
	}

	for (size_t i=0; i<strlen(_pstrFrom); i++)
    {
        if (!isdigit(_pstrFrom[i]))
        {
			if(i == 0 && _pstrFrom[i] == '-' && strlen(_pstrFrom) > 1)
			{
				continue;
			}
            return _iDef;
        }
    }

    return atoi(_pstrFrom);
}

int SafeGetInt()
{
    char cTemp[256] = {0};
    gets_s(cTemp,8);
	if(0 == strcasecmp("q", cTemp))
    {
        exit(0); 
    }

    return to_int_def(cTemp,0);
}

unsigned int IPToDOWRD(const char* _cIP)
{
    if(_cIP == NULL)
        return 0;

    unsigned int ulIP = 0;
    int bt0 = 0;
    int bt1 = 0;
    int bt2 = 0;
    int bt3 = 0;
    sscanf(_cIP,"%d.%d.%d.%d",&bt0,&bt1,&bt2,&bt3);

    ulIP = (bt0<<24) | (bt1<<16) |(bt2<<8) | (bt3);
    return ulIP;
}

void* threadPushStream(void* _pvPara)
{
	int j, k, iReadLen, iSendLen;
	char cFrameBuf[512*1024];
	S_FrameHeader frameHeader;

	int iRet = -1;

	while(!g_bStopSendThread)
	{
		for(size_t i=0;i<m_VecDecoder.size();i++)
		{
			for(j=0; j<DEC_MAX_CHANNEL_NUM_NEW+DEC_MAX_VIRTUAL_CHANNEL_NUM; j++)
			{
				for(k=0; k<DEC_MAX_PICTURE_NUM; k++)
				{
					if(m_VecDecoder[i].m_stPush[j][k].m_bStart == 1)
					{
						while(m_VecDecoder[i].m_stPush[j][k].m_pFile && !feof(m_VecDecoder[i].m_stPush[j][k].m_pFile))
						{
							iReadLen = fread(&frameHeader,sizeof(char),sizeof(frameHeader),m_VecDecoder[i].m_stPush[j][k].m_pFile);
							if(static_cast<unsigned>(iReadLen) < sizeof(frameHeader))
							{
								fseek(m_VecDecoder[i].m_stPush[j][k].m_pFile, sizeof(S_header), SEEK_SET);
								ShowLog("Repeat again!  1");
							}
							if(iReadLen == sizeof(frameHeader))
							{
								int iFrameLen = frameHeader.u32FrameSize - sizeof(frameHeader);
								memcpy(cFrameBuf, &frameHeader, sizeof(frameHeader));
								iReadLen = fread(cFrameBuf+sizeof(frameHeader),sizeof(char),iFrameLen, m_VecDecoder[i].m_stPush[j][k].m_pFile);
								if(iReadLen < iFrameLen)
								{
									fseek(m_VecDecoder[i].m_stPush[j][k].m_pFile, sizeof(S_header), SEEK_SET);
									ShowLog("Repeat again!  2");
								}
								else
								{   //Send the stream
									iSendLen = 0;
									iReadLen += sizeof(frameHeader);
									//ShowLog(string("Frame len = ") + IntToStr(iReadLen));
									//
									cFrameBuf[iReadLen]='F';
									cFrameBuf[iReadLen+1]='E';
									cFrameBuf[iReadLen+2]='O';
									cFrameBuf[iReadLen+3]='F';
									cFrameBuf[iReadLen+4]=(((frameHeader.u32FrameSize+8)&0xff0000)>>16);
									cFrameBuf[iReadLen+5]=(((frameHeader.u32FrameSize+8)&0xff000000)>>24);
									cFrameBuf[iReadLen+6]=((frameHeader.u32FrameSize+8)&0xff);
									cFrameBuf[iReadLen+7]=(((frameHeader.u32FrameSize+8)&0xff00)>>8);
									iReadLen += 8;
									//
									//char cAllData[1440] = {0};
									while(iReadLen >= 1432)
									{	
	//  								unsigned int ulIP = IPToDOWRD("127.0.0.1");
	//  								memcpy(cAllData, "NVS\0\0\0", 4);
	//  								memcpy(cAllData+4, &ulIP, 4);
	//  								memcpy(cAllData+8, cFrameBuf+iSendLen, 1432);
	//  								iRet = pClsNVD->DEC_ClientSendStream(m_VecDecoder[i].m_stPush[j][k].m_lPushID, 1440, cAllData);
										iRet = pClsNVD->DEC_ClientSendStream(m_VecDecoder[i].m_stPush[j][k].m_lPushID, 1432, cFrameBuf+iSendLen);
										iReadLen -= 1432;
										iSendLen += 1432;
										if (iRet == -1)
										{
											cout<<"Push stream failed! Return:"<<iRet<<endl;
											return NULL;
										}
									}
									if(iReadLen > 0)
									{
	//  								unsigned int ulIP = IPToDOWRD("127.0.0.1");
	//  								memcpy(cAllData, "NVS\0\0\0", 4);
	//  								memcpy(cAllData+4, &ulIP, 4);
	//  								memcpy(cAllData+8, cFrameBuf+iSendLen, iReadLen);
	//  								iRet = pClsNVD->DEC_ClientSendStream(m_VecDecoder[i].m_stPush[j][k].m_lPushID, iReadLen+8, cAllData);
										iRet = pClsNVD->DEC_ClientSendStream(m_VecDecoder[i].m_stPush[j][k].m_lPushID, iReadLen, cFrameBuf+iSendLen);
										if (iRet < 0)
										{
											cout<<"Push stream failed! Return:"<<iRet<<endl;
											return NULL;
										}
									}

									static int iTimes = 0;
									if(iTimes > 100)
									{
										//ShowLog(string("Send one frame, len:") +  IntToStr(frameHeader.u32FrameSize));
										iTimes = 0;
									}
									iTimes++;
								}
							}
							usleep(32*1000);
						}
						ShowLog("Send over!");
					}
				}
			}
		}
		usleep(1);
	}

	return NULL;
}

int main (int argc, char *argv[])
{
	const char *pcLibPath = NULL;
	//cout<<"Please input the NVDSKD's path:(if your make it empty,program will load default path)"<<endl;
	//cout<<">";
	void *dllhandle = NULL;
#ifdef __APPLE__
	pcLibPath = "libnvdsdk.dylib";
#else
	pcLibPath = "libnvdsdk.so";
	const char *pcPelcoPath = "libpelocP.so";

	dllhandle = dlopen(pcPelcoPath, RTLD_LAZY);
	GetControlCode = (pGetControlCode)dlsym(dllhandle, "GetControlCode");
	ReleaseCtrl = (pReleaseCtrl)dlsym(dllhandle, "ReleaseCtrl");
#endif

	
	//ʽ
	cout.setf(ios::left);
	
	g_pNvsArr = new pNVSINFO[MAX_NVSNUM];
	for(int i=0; i<MAX_NVSNUM; i++)
	{
		g_pNvsArr[i] = NULL;
	}

	pClsNVD = new CLS_NVDSDKHelper();
	int iRet = -1;
	iRet = pClsNVD->LoadLibrary((char*)pcLibPath);

	if(iRet <= 0)
	{
		cout<<"Load error!  "<<iRet<<endl;
		return -1;
	}

	//pthread_t tdSend = 0;
	//iRet = pthread_create(&tdSend, NULL, threadPushStream, NULL);/////////!!!!!!ע͵
	//if(iRet != 0)
	//	cout<<"Create sendstream thread failed!"<<endl;

	MakeCMD();
	MajorProc();

	for (int i=0; i<MAX_NVSNUM; i++)
	{
		if (g_pNvsArr[i])
		{
			delete g_pNvsArr[i];
			g_pNvsArr[i] = NULL;
		}
	}
	delete[] g_pNvsArr;

	if (dllhandle)
	{
		ReleaseCtrl();
		dlclose(dllhandle);
	}
	

	g_bStopSendThread = true;

	int j = 0;
	int k = 0;
	for(unsigned int i=0;i<m_VecDecoder.size();++i)
	{
		for(int j=0; j<DEC_MAX_CHANNEL_NUM_NEW+DEC_MAX_VIRTUAL_CHANNEL_NUM; ++j)
		{
			for(int k=0; k<DEC_MAX_PICTURE_NUM; ++k)
			{
				if(0 != m_VecDecoder[i].m_stPush[j][k].m_tdSend)
				{
					pthread_join(m_VecDecoder[i].m_stPush[j][k].m_tdSend, NULL);
				}
			}
		}
	}
	for(size_t i=0;i<m_VecDecoder.size();i++)
	{
		for(j=0; j<DEC_MAX_CHANNEL_NUM_NEW+DEC_MAX_VIRTUAL_CHANNEL_NUM; j++)
		{
			for(k=0; k<DEC_MAX_PICTURE_NUM; k++)
			{
				if(m_VecDecoder[i].m_stPush[j][k].m_bStart == 1)
				{
					fclose(m_VecDecoder[i].m_stPush[j][k].m_pFile);
					m_VecDecoder[i].m_stPush[j][k].m_pFile = NULL;
					m_VecDecoder[i].m_stPush[j][k].m_bStart = 0;
				}
			}
		}
	}
	//if(0 != tdSend)
	//	pthread_join(tdSend, NULL);

	//һҪ
	if (g_bIsSDKStart)
		pClsNVD->DEC_ClientCleanup();

	pClsNVD->FreeLibrary();
	delete pClsNVD;
	pClsNVD = NULL;

	return(1);
}

int LogonDec(int &_iID, char *_pcIP, bool _bIsLogin)
{
	if(!_bIsLogin)
	{
		string strIP;
		string strUsrName = "DEC";
		string strPwd  = "DEC";
		//unsigned short usPort = 3000;
		
		if (NULL == _pcIP)
		{
			cout<<"IP: ";
			cin>>strIP;
		}
		else
		{
			strIP = _pcIP;
		}

		g_bSleep = true;
		_iID = pClsNVD->DEC_ClientLogon((char*)strIP.c_str(), (char*)"Admin", (char*)"1111", 3000);

		g_strCurIP = strIP;
		if(_iID < 0)
		{
			g_bSleep = false;
			cout<<"Logon failed!"<<endl;
			return _iID;
		}

		return 1;
	}

	cout<<"You has login, can't login the same decorder"<<endl;
	return 0;
}


int ShowDecVersion(int _iID)
{
	char pcVer[120];
	pClsNVD->DEC_ClientGetVersion(_iID, pcVer);
	cout<<"Decord verison: "<<pcVer<<endl<<endl;

	return 1;
}

int MakeCMD()
{   
	g_mpCmd[string("quit")] = -1;
	g_mpCmd[string("q")] = -1;
	g_mpCmd[string("start")] = 1;
	g_mpCmd[string("1")] = 1;
	g_mpCmd[string("logondec")] = 2;
	g_mpCmd[string("2")] = 2;
	g_mpCmd[string("listall")] = 3;
	g_mpCmd[string("3")] = 3;
	g_mpCmd[string("shownvs")] = 4;
	g_mpCmd[string("4")] = 4;
	g_mpCmd[string("logoutdec")] = 5;
	g_mpCmd[string("5")] = 5;
	g_mpCmd[string("getdecinfo")] = 6;
	g_mpCmd[string("6")] = 6;
	g_mpCmd[string("getallinfo")] = 7;
	g_mpCmd[string("7")] = 7;

	g_mpCmd[string("setip")] = 8;
	g_mpCmd[string("8")] = 8;
	g_mpCmd[string("setddns")] = 9;
	g_mpCmd[string("9")] = 9;
	g_mpCmd[string("setcom")] = 10;
	g_mpCmd[string("10")] = 10;
	g_mpCmd[string("setalarm")] = 11;
	g_mpCmd[string("11")] = 11;
	g_mpCmd[string("settv")] = 12;
	g_mpCmd[string("12")] = 12;
	g_mpCmd[string("setchannel")] = 13;
	g_mpCmd[string("13")] = 13;
	g_mpCmd[string("setlogo")] = 14;
	g_mpCmd[string("14")] = 14;
	g_mpCmd[string("getlogo")] = 15;
	g_mpCmd[string("15")] = 15;
	g_mpCmd[string("setvga")] = 16;
	g_mpCmd[string("16")] = 16;

	g_mpCmd[string("startview")] = 17;
	g_mpCmd[string("17")] = 17;
	g_mpCmd[string("startloop")] = 18;
	g_mpCmd[string("18")] = 18;
	g_mpCmd[string("stopview")] = 19;
	g_mpCmd[string("19")] = 19;
	g_mpCmd[string("stoploop")] = 20;
	g_mpCmd[string("20")] = 20;

	g_mpCmd[string("addnvs")] = 21;
	g_mpCmd[string("21")] = 21;
	g_mpCmd[string("delnvs")] = 22;
	g_mpCmd[string("22")] = 22;

	g_mpCmd[string("startaudio")] = 23;
	g_mpCmd[string("23")] = 23;
	g_mpCmd[string("stopaudio")] = 24;
	g_mpCmd[string("24")] = 24;
	g_mpCmd[string("starttalk")] = 25;
	g_mpCmd[string("25")] = 25;
	g_mpCmd[string("stoptalk")] = 26;
	g_mpCmd[string("26")] = 26;
	g_mpCmd[string("PTZctrl")] = 27;
	g_mpCmd[string("27")] = 27;
	g_mpCmd[string("485ctrl")] = 28;
	g_mpCmd[string("28")] = 28;
	g_mpCmd[string("rebootdec")] = 29;
	g_mpCmd[string("29")] = 29;
	g_mpCmd[string("resetdec")] = 30;
	g_mpCmd[string("30")] = 30;

	g_mpCmd[string("upkernel")] = 31;
	g_mpCmd[string("31")] = 31;
	g_mpCmd[string("uplogo")] = 32;
	g_mpCmd[string("32")] = 32;
	g_mpCmd[string("upprotocol")] = 33;
	g_mpCmd[string("33")] = 33;
	g_mpCmd[string("upweb")] = 34;
	g_mpCmd[string("34")] = 34;
	g_mpCmd[string("delprotocol")] = 35;
	g_mpCmd[string("35")] = 35;

	g_mpCmd[string("startstream")] = 36;
	g_mpCmd[string("36")] = 36;
	g_mpCmd[string("stopstream")] = 37;
	g_mpCmd[string("37")] = 37;

	g_mpCmd[string("getcap")] = 38;
	g_mpCmd[string("38")] = 38;
	g_mpCmd[string("shownvs")] = 39;
	g_mpCmd[string("39")] = 39;
	g_mpCmd[string("modifynvs")] = 40;
	g_mpCmd[string("40")] = 40;

	g_mpCmd[string("left")] = 41;
	g_mpCmd[string("41")] = 41;
	g_mpCmd[string("up")] = 42;
	g_mpCmd[string("42")] = 42;

	g_mpCmd[string("list protocols")] = 43;
	g_mpCmd[string("43")] = 43;
 
	g_mpCmd[string("SelectPicture")] = 44;
	g_mpCmd[string("44")] = 44;

	g_mpCmd[string("StreamControl")] = 45;
	g_mpCmd[string("45")] = 45;

	g_mpCmd[string("ConnectAllPushVideo")] = 46;
	g_mpCmd[string("46")] = 46;

	g_mpCmd[string("AddNVS_Ex")] = 47;
	g_mpCmd[string("47")] = 47;

	g_mpCmd[string("StartStream_V1")] = 48;
	g_mpCmd[string("48")] = 48;

	g_mpCmd[string("SetVolume")] = 49;
	g_mpCmd[string("49")] = 49;

	g_mpCmd[string("SetPreviewPreference")] = 50;
	g_mpCmd[string("50")] = 50;

	g_mpCmd[string("SetNetCutHoldLastFrame")] = 51;
	g_mpCmd[string("51")] = 51;

	g_mpCmd[string("GetAlarmLinkSwitch")] = 52;
	g_mpCmd[string("52")] = 52;

	g_mpCmd[string("ShowVVOInfo")] = 53;
	g_mpCmd[string("53")] = 53;

	g_mpCmd[string("ShowSplitScreenInfo")] = 54;
	g_mpCmd[string("54")] = 54;

	g_mpCmd[string("SetAlarmLinkSwitch")] = 55;
	g_mpCmd[string("55")] = 55;

	g_mpCmd[string("CreateVVO")] = 56;
	g_mpCmd[string("56")] = 56;

	g_mpCmd[string("GetChannelState")] = 57;
	g_mpCmd[string("57")] = 57;

	g_mpCmd[string("SetAlarmSchedule")] = 58;
	g_mpCmd[string("58")] = 58;

	g_mpCmd[string("GetAlarmSchedule")] = 59;
	g_mpCmd[string("59")] = 59;

	g_mpCmd[string("SetAlarmLink")] = 60;
	g_mpCmd[string("60")] = 60;

	g_mpCmd[string("GetAlarmLink")] = 61;
	g_mpCmd[string("61")] = 61;

	g_mpCmd[string("SetAlarmInAndOut")] = 62;
	g_mpCmd[string("62")] = 62;

	g_mpCmd[string("GetAlarmInAndOut")] = 63;
	g_mpCmd[string("63")] = 63;

	g_mpCmd[string("SetSplitScreen")] = 64;
	g_mpCmd[string("64")] = 64;

	g_mpCmd[string("SetScheduleEnable")] = 65;
	g_mpCmd[string("65")] = 65;

	g_mpCmd[string("GetScheduleEnable")] = 66;
	g_mpCmd[string("66")] = 66;

	return g_mpCmd.size();
}

int MajorProc(bool bStart)
{
	cout<<"-----------Welcome use NVDSDK----------"<<endl;

	string strCmd;
	//int iCmd;
	bool bQuit = false;
	int  iRet = -1;
	//string strInnerCmd[128];
	string strSpilt = ",";
	int iID = -1;					//ӱʶ
	bool bIsLogin = false;		   	//Ƿѵ

	while(!bQuit)
	{
		//ȷ:
		if (!g_bSleep)
		{
			//wxl add
			fprintf(stderr, "[q]quit	\n"
					"[1]start         	[2]logondec     	[3]listall      	[4]shownvs      	[5]logoutdec		\n"
					"[6]getdecinfo    	[7]getallinfo   	[8]setip        	[9]setddns      	[10]setcom			\n"
					"[11]setalarm     	[12]settv       	[13]setchannel  	[14]setlogo     	[15]getlogo			\n"
					"[16]setvga       	[17]startview   	[18]startloop   	[19]stopview    	[20]stoploop		\n"
					"[21]addnvs       	[22]delnvs      	[23]startaudio  	[24]stopaudio   	[25]starttalk		\n"
					"[26]stoptalk     	[28]485ctrl     	[29]rebootdec   	[30]resetdec		[31]upkernel		\n"
					"[32]uplogo       	[33]upprotocol  	[34]upweb       	[35]delprotocol		[36]startstream		\n"
					"[37]stopstream   	[38]getcap      	[40]modifynvs		[43]lstprotocols	[44]SelectPicture		\n"
					"[45]StreamControl	[48]StartStream_V1 	[49]SetVolume		[50]SetPreference	[51]SetLastFrame\n"
					"[52]GetLinkSwitch	[53]ShowVVOInfo		[54]ShowSplitScreen 	[55]SetLinkSwitch	[56]CreateVVO\n"
					"[57]GetChannelState	[58]SetAlarmSchedule	[59]GetAlarmSchedule	[60]SetAlarmLink	[61]GetAlarmLink\n"
					"[62]SetAlarmInAndOut	[63]GetAlarmInAndOut	[64]SetSplitScreen	[65]SetScheduleEnable	[66]GetScheduleEnable\n");

			//wxl end
			cout<<endl<<"Please input your correct command: "<<endl;
			cout<<">";
			cin>>strCmd;
			//cin>>iCmd;
			//SplitStringToArray(strCmd,strSpilt,strInnerCmd);
			//cout<<g_mpCmd[strCmd]<<endl;

			//switch(g_mpCmd[strCmd]) 
			//int iCmd = atoi(strCmd.c_str());
			//printf("cmd = %d\n", iCmd);
			switch(g_mpCmd[strCmd])  
			{
			case -1:   //q
				cout<<"Goodbye, my friend!"<<endl;
				//pClsNVD->DEC_ClientCleanup();
				bQuit = true;
				break;
			case 1:
				iRet = pClsNVD->DEC_ClientStartup(START_MSG, NULL);
				if(iRet < 0)
				{
					cout<<"Start failed!:"<<iRet<<endl;
				}
				else
				{
					cout<<"Start success!"<<endl;
					pClsNVD->DEC_ClientSetComRecvNotify(ComRecvNotify);
					pClsNVD->DEC_ClientSetMsgCallback(MyPostMsg);
					g_bIsSDKStart = true;
				}
				break;
			case 2:
				iRet = LogonDec(iID, NULL, bIsLogin);
				if (iRet < 0)
				{
					cout<<"Maybe you forget to start our SDK  "<<"return:"<<iRet<<endl;
					g_bSleep = false;
				}
				break;
			case 3:
				ListAllLogin();
				break;
			case 5:
				LogoutDec();
				break;
			case 6:
				ShowDECInfo();
				break;
			case 7:
				ShowAllDECInfo();
				break;
			case 8:
				SetDECIP();
				break;
			case 9:
				SetDDNS();
				break;
			case 10:
				SetCom();
				break;
			case 11:
				SetAlarm();
				break;
			case 12:
				SetTV();
				break;
			case 13:
				SetChannel();
				break;
			case 14:
				SetLogo();
				break;
			case 15:
				GetLogo();
				break;
			case 16:
				SetVGASize();
				break;
			case 17:
				StartView();
				break;
			case 18:
				StartLoop();
				break;
			case 19:
				StopView();
				break;
			case 20:
				StopLoop();
				break;
			case 21:
				AddNVS();
				break;
			case 22:
				DelNVS();
				break;
			case 23:
				StartAudio();
				break;
			case 24:
				StopAudio();
				break;
			case 25:
				StartTalk();
				break;
			case 26:
				StopTalk();
				break;
			case 27:
				PTZCtrl();
				break;
			case 28:
				DEC485Ctrl();
				break;
			case 29:
				RebootDec();
				break;
			case 30:
				ResetDec();
				break;
			case 31:
				UpgradeKernel();
				break;
			case 32:
				UpgradeLogo();
				break;
			case 33:
				UpgradeProtocol();
				break;
			case 34:
				UpgradeWeb();
				break;
			case 35:
				DeleteProtocol();
				break;
			case 36:
				StartPushStream();
				break;
			case 37:
				StopPushStream();
				break;
			case 38:
				GetCapability();
				break;
			case 4:
				ShowNVSInfo();
				break;
			case 40:
				ModifyNVS();
				break;
			case 43:
				ListProtocol();
				break;
			case 44:
				SelectPicture();
				break;
			case 45:
				StreamControl();
				break;
			case 46:
				ConnectAllPushVideo();
				break;
			case 47:
				AddNVS_Ex();
				break;
			case 48:
				StartPushStream_V1();
				break;
			case 49:
				SetVolume();
				break;
			case 50:
				SetPreviewPreference();
				break;
			case 51:
				SetNetCutHoldLastFrame();
				break;
			case 52:
				GetAlarmLinkSwitch();
				break;
			case 53:
				ShowVVOInfo();
				break;
			case 54:
				ShowSplitScreenInfo();
				break;
			case 55:
				SetAlarmLinkSwitch();
				break;
			case 56:
				CreateVVO();
				break;
			case 57:
				GetChannelState();
				break;
			case 58:
				SetAlarmSchedule();
				break;
			case 59:
				GetAlarmSchedule();
				break;
			case 60:
				SetAlarmLink();
				break;
			case 61:
				GetAlarmLink();
				break;
			case 62:
				SetAlarmInAndOut();
				break;
			case 63:
				GetAlarmInAndOut();
				break;
			case 64:
				SetSplitScreen();
				break;
			case 65:
				SetScheduleEnable();
				break;
			case 66:
				GetScheduleEnable();
				break;
			default:
				cout<<"Command \""<<strCmd<<"\" not found!\n"<<endl;
				//bQuit = true;
				break;
			}
		}
		sleep(1);
	}

	return 1;
}

int ListAllLogin()
{	
	cout<<setw(4)<<"ID"<<setw(16)<<"IP"<<endl;
	for (size_t i=0; i<m_VecDecoder.size(); i++)
	{
		if (0 != strcmp(m_VecDecoder[i].m_cIP, ""))
		{
			cout<<setw(4)<<i<<setw(16)<<m_VecDecoder[i].m_cIP<<endl;
		}
	}
	cout<<endl;

	return 1;
}

int LogoutDec(int _iID)
{
	int iID;

	if (-1 == _iID)
	{
		SafeGetInt();
		cout<<"Which do you want to logout?"<<endl<<"ID: ";
		//cin>>iID;
		iID = SafeGetInt();
	}
	else
	{
		iID = _iID;
	}

	for(unsigned int i=0;i<m_VecDecoder.size();++i)
	{
		for(int j=0; j<DEC_MAX_CHANNEL_NUM_NEW+DEC_MAX_VIRTUAL_CHANNEL_NUM; ++j)
		{
			for(int k=0; k<DEC_MAX_PICTURE_NUM; ++k)
			{
				if(m_VecDecoder[i].m_stPush[j][k].m_bStart == 1)
				{
					pClsNVD->DEC_ClientStopPushStream(m_VecDecoder[i].m_stPush[j][k].m_lPushID);
					//DEC_ClientStopPushStreamEx(m_VecDecoder[i].m_stPush[j][k].m_lPushID, iShowLastPic);
					if (m_VecDecoder[i].m_stPush[j][k].m_pFile)
					{
						m_VecDecoder[i].m_stPush[j][k].m_bStart = 0;
						fclose(m_VecDecoder[i].m_stPush[j][k].m_pFile);
						m_VecDecoder[i].m_stPush[j][k].m_pFile = NULL;
					}
				}
			}
		}
	}
	
	pClsNVD->DEC_ClientLogout(iID);
	memset(m_VecDecoder[iID].m_cIP, 0, sizeof(m_VecDecoder[iID].m_cIP));

	return 1;
}

int MyPostMsg(void *_hWnd, unsigned int _uiMsg, unsigned int _wParam, int _lParam)
{

	//g_bSleep = true;
	short sWParaLo = _wParam & 0x0000FFFF;
	short sWParaHi = (_wParam>>16) & 0x0000FFFF;

	short iMsgType = sWParaLo;
	int iID = _lParam;

	int iLogonState = -1;
	string astrMsg = "";
	string astrIP = "";
	int iChannel = -1;
	int iPos = -1;
	//int i = 0;
	int j = 0;
	int k = 0;

	switch (iMsgType)
	{
	case DEC_WCM_DEC_LOGON:
		{
			iLogonState = sWParaHi;

			//ViewϢ
			//UpdateTreeView(iID,iLogonState);
			if (iLogonState == DEC_LOGON_SUCCESS)
			{
				astrMsg = "DEC_LOGON_SUCCESS";

				cout<<"     Logon success!ID is:    "<<iID<<endl<<endl;
				ShowDecVersion(iID);

				strcpy(m_VecDecoder[iID].m_cIP,(char *)g_strCurIP.c_str());

				cout<<"We will record the all nvs'information of this decoder..Thank you!"<<endl;
				RecordNVSInfo();
			}
			else if (iLogonState == DEC_LOGON_TIMEOUT)
			{
				astrMsg = "DEC_LOGON_TIMEOUT";
			}
			else if (iLogonState == DEC_LOGON_FAILED)
			{
				astrMsg = "DEC_LOGON_FAILED";
			}
			ShowLog(string("[MSG]: ") + astrMsg + string(":") + IntToStr(_lParam));
			
			g_bSleep = false;

			break;
		}
	case DEC_WCM_NVS_STARTVIEW:
		ShowLog("[MSG]: STARTVIEW");

		iChannel = ((short)sWParaHi & 0xF0)>>4;
		iPos = (short)sWParaHi & 0x0F;
		//ûв

		break;

	case DEC_WCM_NVS_STOPVIEW:
		{
			ShowLog("[MSG]: STOPVIEW");

			iChannel = ((short)sWParaHi & 0xF0)>>4;
			iPos = (short)sWParaHi & 0x0F;

			break;
		}
	case DEC_WCM_DEC_TALK:
		{
			ShowLog("[MSG]: DEC_TALK");
			break;
		}
	case DEC_WCM_DEC_UPGRADE:                 //LParam:ID,WParamHi:0--ɹ
		{
			ShowLog("[MSG]: DEC_UPGRADE");
			break;
		}
	case DEC_WCM_DEC_UPGRADELOGO:
		{
			ShowLog("[MSG]: DEC_UPGRADELOGO");
			break;
		}
	case DEC_WCM_DEC_UPGRADEP:
		{
			ShowLog("[MSG]: DEC_UPGRADEP");
			break;
		}
	case DEC_WCM_ERR_ORDER:
		{
			ShowLog("[MSG]: ERR_ORDER");
			g_bSleep = false;
			break;
		}
	case DEC_WCM_DEC_PARASET:
		{
			ShowLog("[MSG]: DEC_PARAMER SET");
			break;
		}
	case DEC_WCM_DEC_UPGRADEWEB:
		{
			ShowLog("[MSG]: DEC_UPGRADE WEB");
			break;
		}
	case DEC_WCM_DEC_UPGRADEPROCESS:
		{
			static int iLastProcess = 0;
			if(sWParaHi > iLastProcess+2)
			{
				fprintf(stderr, "#");
				iLastProcess = sWParaHi;
			}
			if(100 == sWParaHi)
			{
				iLastProcess = 0;
				printf("\n>");
			}

			break;
		}
	case DEC_WCM_DEC_AUDIOSTATUS:
		{
			ShowLog("[MSG]: DEC_WCM_DEC_AUDIOSTATUS");
			break;
		}
	case DEC_WCM_DEC_TALK_FAILED:
		{
			iChannel = ((short)sWParaHi&0xF0)>>4;
			iPos = (short)sWParaHi&0xF;
			ShowLog("[MSG]: Talk failed!" + string("Chan:") + IntToStr(iChannel) + string(" Pos:") + IntToStr(iPos));
			break;
		}
	case DEC_WCM_DEC_AUDIO_FAILED:
		{
			ShowLog("[MSG]: Open audio failed!");
			break;
		}
	case DEC_WCM_DEC_PUSHSTREAM:
		{
			ShowLog("[MSG]: DEC_WCM_DEC_PUSHSTREAM");

			int iResult = sWParaHi;
			if(iResult == ERR_SUCCESS)
			{
				for(size_t i=0;i<m_VecDecoder.size();i++)
				{
					for(j=0; j<DEC_MAX_CHANNEL_NUM_NEW+DEC_MAX_VIRTUAL_CHANNEL_NUM; j++)
					{
						for(k=0; k<DEC_MAX_PICTURE_NUM; k++)
						{
							if(m_VecDecoder[i].m_stPush[j][k].m_lPushID == iID)
							{
								m_VecDecoder[i].m_stPush[j][k].m_bStart = 1;
								ShowLog(string("Start iID:") + IntToStr(i) + string(" Chan:") + IntToStr(j)
										+ string(" Pos:") + IntToStr(k));
							}
						}
					}
				}
			}
			else if(1 == iResult)
			{
				//ʧܴDEC_ClientStartPushStream(0, 0, 0, 0, 4);
			}
			else
			{
				//TODO:nothing.....
			}
			break;
		}
	case DEC_WCM_ERR_PUSHSTREAM:
		{
			ShowLog("[MSG]: DEC_WCM_ERR_PUSHSTREAM");

			for(size_t i=0;i<m_VecDecoder.size();++i)
			{
				for(j=0; j<DEC_MAX_CHANNEL_NUM_NEW+DEC_MAX_VIRTUAL_CHANNEL_NUM; j++)
				{
					for(k=0; k<DEC_MAX_PICTURE_NUM; k++)
					{
						if(m_VecDecoder[i].m_stPush[j][k].m_lPushID == iID)
						{
							m_VecDecoder[i].m_stPush[j][k].m_bStart = 0;
							ShowLog(string("!!Start iID:") + IntToStr(i) + string(" Chan:") + IntToStr(j) 
									+ string(" Pos:") + IntToStr(k) + string(" Error!"));
						}
					}
				}
			}

			break;
		}
	case DEC_WCM_ALARM_NOTIFY:
		{
			//GetAlarmNotify();
		}

	default:
		break;
	}
	
	return 1;
}

void ComRecvNotify(long _iID, char *_pcBuf, int _iLength)
{
	string asRecv = "[DEC] Com received data: ";
	unsigned char temp;
	char cmd[1024];
	memset(cmd, 0, 1024);
	for (int i=0; i<_iLength; i++)
	{
		temp = *(_pcBuf + i);
		sprintf(&cmd[i*3], " %.2x", temp);
	}
	//sprintf(asRecv, "%s(%d)%s" ,asRecv,_iLength,cmd);
	asRecv = asRecv + "("+ IntToStr(_iLength) + ")" + string(cmd);
	cout<<asRecv<<endl;

	return;
}

int ShowLog(string _strlog, bool bWrFile)
{
	if (_strlog.empty())
	{
		cout<<"Null string!"<<endl;
		return -1;
	}

	if (bWrFile)
	{

	}
	else
	{
		cout<<_strlog<<endl;
	}

	return 1;
}

string IntToStr(int _itemp)
{
	int   m = abs(_itemp);
	int   n = 0;
	int   k = 0;
	char  str[16] = {0};
	char  strRet[16] = {0};

	if (m < 10)
	{
		str[0] = m + 48;
		str[1] = 0;
		strcpy(strRet,str);

		return string(strRet);
	}

	while(m/10 > 0)
	{
		n = m - m/10*10;
		str[k] = n + 48;
		m /= 10;
		if(m < 10)
			str[k+1] = m + 48;
		k++;
	}

	for(int i=k; i>=0; i--)
	{
		strRet[k-i] = str[i];
	}

	return string(strRet);
}

int ShowNVSInfo(int _iID, int _iChan, int _iPos)
{
	int iID = -1;
	int iChan = -1;
	int iPos = -1;

	if (-1==_iID || -1==_iChan || -1==_iPos)
	{
		SafeGetInt();

		cout<<"Specify decorder id:"<<endl;
		//cin>>iID;
		iID = SafeGetInt();
		cout<<"Specify decorder channel:"<<endl;
		//cin>>iChan;
		iChan = SafeGetInt();
		cout<<"Picture no:"<<endl;
		//cin>>iPos;
		iPos = SafeGetInt();
	}
	else
	{
		iID = _iID;
		iChan = _iChan;
		iPos = _iPos;
	}

	TNVSITEMEX nvsItemEx = {0};
	nvsItemEx.m_iStructLen = sizeof(TNVSITEMEX);

	int iItemNum = -1;
	//cout<<iID<<iChan<<iPos<<endl;
	iItemNum = pClsNVD->DEC_ClientGetLoopItemCount(iID,iChan,iPos);
	
	if (iItemNum < 0)
	{
		cout<<"Check channel or Picture no, Return:"<<iItemNum<<endl;
		return iItemNum;
	}
	cout<<"NVS information:"<<endl;
	cout<<setw(6)<<"DecID"<<setw(7)<<"NVSInx"<<setw(30)<<"IP"<<setw(8)<<"Channel"<<setw(16)<<"PROXY"
		<<setw(7)<<"Stream"<<setw(8)<<"NetMode"<<setw(6)<<"Port"<<setw(10)<<"User"<<setw(7)<<"PWD"
		<<setw(10)<<"PlatType"<<setw(10)<<"EncyptPWD"<<endl;

	for (int i=0; i<iItemNum; i++)
	{
		nvsItemEx.m_iStructLen = sizeof(TNVSITEMEX);
		int iRet = pClsNVD->DEC_ClientGetLoopItemEx(iID, i, &nvsItemEx, iChan, iPos);
		if (iRet < 0)
		{
			cout<<"GetLoop failed! Return:"<<iRet<<endl;
			return iRet;
		}
		
		const char *netMode = NULL;
		switch(nvsItemEx.m_stOldItem.m_serNetmode)
		{
		case 1:
			netMode = "TCP";
			break;
		case 2:
			netMode = "UDP";
			break;
		case 3:
			netMode = "MU";
			break;
		default:
			netMode = "Unknown";
			break;
		}
		//޸ļʾRTSP
		if (DEVTYPE_RTSP != nvsItemEx.m_iDevPlatType) 
		{
			cout<<setw(6)<<iID<<setw(7)<<i<<setw(30)<<nvsItemEx.m_stOldItem.m_serIP<<setw(16)<<nvsItemEx.m_stOldItem.m_serProxy
			<<setw(8)<<nvsItemEx.m_stOldItem.m_serChan+1<<setw(7)<<(nvsItemEx.m_stOldItem.m_serStream == 0?"main":"sub")<<setw(8)<<netMode
			<<setw(6)<<nvsItemEx.m_stOldItem.m_serPort<<setw(10)<<nvsItemEx.m_stOldItem.m_username<<setw(7)<<"******"
			<<setw(10)<<nvsItemEx.m_iDevPlatType<<setw(14)<<nvsItemEx.m_cEncyptPWD<<endl;
		}
		else
		{
			cout<<setw(6)<<iID<<setw(7)<<i<<setw(46)<<nvsItemEx.m_stOldItem.m_cRTSPUrl
			<<setw(8)<<nvsItemEx.m_stOldItem.m_serChan+1<<setw(7)<<(nvsItemEx.m_stOldItem.m_serStream == 0?"main":"sub")<<setw(8)<<netMode
			<<setw(6)<<nvsItemEx.m_stOldItem.m_serPort<<setw(10)<<nvsItemEx.m_stOldItem.m_username<<setw(7)<<"******"
			<<setw(10)<<nvsItemEx.m_iDevPlatType<<setw(14)<<nvsItemEx.m_cEncyptPWD<<endl;
		}
	}
	
	return 1;
}

int ShowDECInfo()
{
	SafeGetInt();

	cout<<"Which do you want to show?"<<endl<<"ID: ";
	int iID = -1;
	//cin>>iID;
	iID = SafeGetInt();

	TDECPARAM *tp = new TDECPARAM();
	int iRet = pClsNVD->DEC_ClientGetDecoderPara(iID, tp);
	if (iRet == 0)
	{
		cout<<setw(4)<<"ID"<<setw(16)<<"IP"<<setw(16)<<"Submask"<<setw(16)<<"Gatway"<<endl;
		cout<<setw(4)<<iID<<setw(16)<<tp->m_ip<<setw(16)<<tp->m_submask<<setw(16)<<tp->m_gateway<<endl;
	}	

	return 1;
}

int ShowAllDECInfo()
{
	cout<<setw(4)<<"ID"<<setw(16)<<"IP"<<setw(16)<<"Submask"<<setw(16)<<"Gatway"<<endl;
	for (size_t i=0; i<m_VecDecoder.size(); i++)
	{
		TDECPARAM *tp = new TDECPARAM();
		int iRet = pClsNVD->DEC_ClientGetDecoderPara(i, tp);
		if (iRet == 0)
		{
			cout<<setw(4)<<i<<setw(16)<<tp->m_ip<<setw(16)<<tp->m_submask<<setw(16)<<tp->m_gateway<<endl;
		}
	}
		
	return 1;
}

int SetDECIP()
{
	SafeGetInt();

	int iID = -1;
	string pcIP;
	string submask;
	string gateway;
	string dns;
	cout<<"Specify decorder id: "<<endl;
	//cin>>iID;
	iID = SafeGetInt();
	cout<<"Specify ip: "<<endl;
	cin>>pcIP;
	cout<<"submask: "<<endl;
	cin>>submask;
	cout<<"gateway: "<<endl;
	cin>>gateway;
	cout<<"dns:"<<endl;
	cin>>dns;
	
	int iRet = -1;
	iRet = pClsNVD->DEC_ClientSetIP(iID,(char *)pcIP.c_str(),(char *)submask.c_str(),(char *)gateway.c_str(),(char *)dns.c_str());
	
	if (iRet < 0)
	{
		cout<<"Set failed!Error code:"<<iRet<<endl;
		return iRet;
	}
	else
	{
		RebootDec(iID);
		pClsNVD->DEC_ClientLogout(iID);
		g_bSleep = true;
		cout<<"IP changing,wait......"<<endl;
		sleep(10);
		LogonDec(iID, (char *)pcIP.c_str(), false);
	}

	return 1;
}

int SetDDNS()
{
	SafeGetInt();

	int iID = -1;
	string cSvrIP;
	string cUserName;
	string cPassword;
	int iPort;
	
	cout<<"Specify ID: "<<endl;
	//cin>>iID;
	iID = SafeGetInt();
	cout<<"server IP: "<<endl;
	cin>>cSvrIP;
	cout<<"user name: "<<endl;
	cin>>cUserName;
	cout<<"password: "<<endl;
	cin>>cPassword;

	SafeGetInt();
	cout<<"port:"<<endl;
	//cin>>iPort;
	iPort = SafeGetInt();

	int iRet = -1;
	iRet = pClsNVD->DEC_ClientSetDDNS(iID, (char*)cSvrIP.c_str(), (char*)cUserName.c_str(), (char*)cPassword.c_str(), iPort);
	
	if (iRet < 0)
	{
		cout<<"Set failed!"<<endl;
		return iRet;
	}

	return 1;
}

int SetCom()
{
	SafeGetInt();

	int iID = -1;
	int iType = -1;
	int iAddress = -1;
	int iBaudrate = -1;
	int iDatabit = -1;
	int iStopbit = -1;
	int iCheckbit = -1;
	int iFlowCtrl = 0;
	int iCom = -1;
	
	cout<<"ID: "<<endl;
	//cin>>iID;
	iID = SafeGetInt();
	cout<<"type:[0,1] "<<endl;
	//cin>>iType;
	iType = SafeGetInt();
	cout<<"address: (0,255)"<<endl;
	//cin>>iAddress;
	iAddress = SafeGetInt();
	cout<<"baudrate:[57600, 38400, 19200, 9600, 4800, 2400] "<<endl;
	//cin>>iBaudrate;
	iBaudrate = SafeGetInt();
	cout<<"data bit:[7,8]"<<endl;
	//cin>>iDatabit;
	iDatabit = SafeGetInt();
	cout<<"stop bit: [1,2]"<<endl;
	//cin>>iStopbit;
	iStopbit = SafeGetInt();
	cout<<"check bit:[0,1,2] "<<endl;
	//cin>>iCheckbit;
	iCheckbit = SafeGetInt();
	cout<<"iCom:[0,1] "<<endl;
	//cin>>iCom;
	iCom = SafeGetInt();

	int iRet = pClsNVD->DEC_ClientSetCom(iID, iType, iAddress, iBaudrate, iDatabit, iStopbit, iCheckbit, iFlowCtrl, iCom);
	if (iRet < 0)
	{
		cout<<"Set failed!"<<endl;
		return iRet;
	}

	return 1;
}

int SetAlarm()
{
	SafeGetInt();

	int iID = -1;
	int iAlarmOut = -1;
	int iAlarmMode = -1;
	
	cout<<"ID: "<<endl;
	//cin>>iID;
	iID = SafeGetInt();
	cout<<"alarm out: "<<endl;
	//cin>>iAlarmOut;
	iAlarmOut = SafeGetInt();
	cout<<"alarm mode: "<<endl;
	//cin>>iAlarmMode;
	iAlarmMode = SafeGetInt();

	int iRet = pClsNVD->DEC_ClientSetAlarmOut(iID, iAlarmOut, iAlarmMode);
	
	if (iRet < 0)
	{
		cout<<"Set failed!"<<endl;
		return iRet;
	}

	return 1;
}

int SetTV()
{
	SafeGetInt();

	int iID  = -1;
	int iIsPAL  = -1;
	int iLangu = -1;

	cout<<"ID: "<<endl;
	//cin>>iID;
	iID = SafeGetInt();
	cout<<"PAL(0:P,1:N): "<<endl;
	//cin>>iIsPAL;
	iIsPAL = SafeGetInt();
	cout<<"lauguage:(0:CH,1:EN) "<<endl;
	//cin>>iLangu;
	iLangu = SafeGetInt();

	int iRet  = pClsNVD->DEC_ClientSetTVInfo(iID, iIsPAL, iLangu);
	
	if (iRet < 0)
	{
		cout<<"Set failed!"<<endl;
		return iRet;
	}

	return 1;
}

int SetChannel()
{
	SafeGetInt();

	int iID = -1;
	int iChannel = -1;
	int iMode = -1;

	cout<<"ID: "<<endl;
	//cin>>iID;
	iID = SafeGetInt();
	cout<<"channel: "<<endl;
	//cin>>iChannel;
	iChannel = SafeGetInt();
	cout<<"mode: "<<endl;
	//cin>>iMode;
	iMode = SafeGetInt();

	int iRet = pClsNVD->DEC_ClientSetChannelMode(iID, iChannel, iMode);
	
	if (iRet < 0)
	{
		cout<<"Set failed!"<<endl;
		return iRet;
	}

	return 1;
}

int SetLogo()
{
	SafeGetInt();

	int iID = -1;
	cout<<"ID: "<<endl;
	//cin>>iID;
	iID = SafeGetInt();

	TLOGOPARAM tlp = {0};
	cout<<"Want to overlay logo?(1:yes,0:no): ";
	int iEnable = 0;
	//cin>>iEnable;		//tlp.m_enable char.......
	iEnable = SafeGetInt();
	tlp.m_enable = (unsigned char)iEnable;
	cout<<"position X: ";
	//cin>>tlp.m_iPosX;
	tlp.m_iPosX = SafeGetInt();
	cout<<"position Y: ";
	//cin>>tlp.m_iPosY;
	tlp.m_iPosY = SafeGetInt();
	cout<<"background color: ";
	//cin>>tlp.m_iTransparentColor;
	tlp.m_iTransparentColor = SafeGetInt();
	cout<<"alpha: ";
	int iAlpha = 0;
	//cin>>iAlpha;
	iAlpha = SafeGetInt();
	tlp.m_iAlpha = (unsigned char)iAlpha;
	
	int iRet = pClsNVD->DEC_ClientSetLogo(iID,&tlp);
	if (iRet < 0)
	{
		cout<<"Set failed, ret = "<<iRet<<endl;
		return iRet;
	}

	return 1;
}

int GetLogo()
{
	SafeGetInt();

	int iID = -1;
	cout<<"Input decorder id: "<<endl;;
	//cin>>iID;
	iID = SafeGetInt();
	TLOGOPARAM tlp = {0};

	int iRet = pClsNVD->DEC_ClientGetLogo(iID, &tlp);
	if (iRet < 0)
	{
		cout<<"Get failed!"<<endl;
		return iRet;
	}

	cout<<setw(8)<<"overlay"<<setw(8)<<"posX"<<setw(8)<<"posY"<<setw(8)<<"bgcolor"<<setw(8)<<"alpha"<<endl;
	cout<<setw(8)<<(tlp.m_enable == 0?"No":"Yes")<<setw(8)<<tlp.m_iPosX<<setw(8)<<tlp.m_iPosY<<setw(8)
		<<tlp.m_iTransparentColor<<setw(8)<<(int)tlp.m_iAlpha<<endl;	

	return 1;
}

int SetVGASize()
{
	SafeGetInt();

	int iID = -1;
	int iChannel = -1;
	int iSize = -1;
	cout<<"ID: "<<endl;
	//cin>>iID;
	iID = SafeGetInt();
	cout<<"channel: "<<endl;
	//cin>>iChannel;
	iChannel = SafeGetInt();
	cout<<"size:(1:800*600Hz, 2:1024*768Hz, 3:1280*1024Hz, 4:1280*720P 60HZ, "
		  "5:1920*1080P 60HZ, 6:1280*720P 50HZ, 7:1920*1080P 50HZ, 8:1920*1080I 60HZ"
		  "9:1920*1080I 50HZ, 10:1366*768 60Hz, 11:1440*900 60Hz, 12:1280*800 60Hz)"<<endl;
	//cin>>iSize;
	iSize = SafeGetInt();
	int iRet = pClsNVD->DEC_ClientSetVGASize(iID, iChannel, iSize);
	if (iRet < 0)
	{
		cout<<"Set failed!"<<endl;
		return iRet;
	}

	return 1;
}


int StartView()
{
	cout<<"Show NVS Info:"<<endl;
	RecordNVSInfo();
	cout<<"Begin view:"<<endl;

	int iID = -1;
	int iChannel = -1;
	int iPos  = -1;
	int iNVSIndex = -1;

	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();
	cout<<"Channel:"<<endl;
	//cin>>iChannel;
	iChannel = SafeGetInt();
	cout<<"Picture no."<<endl;
	//cin>>iPos;
	iPos = SafeGetInt();

	if (pClsNVD->DEC_ClientGetLoopStatus(iID,iChannel,iPos))
	{
		cout<<"Looping.."<<endl;
		return -1;
	}
	
	cout<<"Please specify nvs index:"<<endl;
	//cin>>iNVSIndex;
	iNVSIndex = SafeGetInt();

	int iRet = -1;
	if (g_pNvsArr[iNVSIndex])
	{
		g_pNvsArr[iNVSIndex]->m_viewItemEx.m_iStructLen = sizeof(TNVSITEMEX);
		iRet = pClsNVD->DEC_ClientStartViewEx(iID,&(g_pNvsArr[iNVSIndex]->m_viewItemEx),iChannel,iPos);
		cout<<"[pClsNVD->DEC_ClientStartViewEx]----iRet="<<iRet<<endl;
	}
	else
	{
		cout<<"Index error! NVSNum = "<<pClsNVD->DEC_ClientGetLoopItemCount(iID,iChannel,iPos)<<endl;
	}
	
	if (0 == iRet)
	{
		cout<<"Start view success!"<<endl;
	}
	return 1;
}

int StopView()
{
	SafeGetInt();

	int iID = -1;
	int iChannel = -1;
	int iPos  = -1;
	int iIsShowLastPic = -1;

	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();
	cout<<"Channel:"<<endl;
	//cin>>iChannel;
	iChannel = SafeGetInt();
	cout<<"Picture no."<<endl;
	//cin>>iPos;
	iPos = SafeGetInt();
	cout<<"Wether show the last pic?1:yes,0:no"<<endl;
	//cin>>iIsShowLastPic;
	iIsShowLastPic = SafeGetInt();

	int iRet = pClsNVD->DEC_ClientStopView(iID,iChannel,iPos,iIsShowLastPic);
	if (0 == iRet)
	{
		cout<<"View stop."<<endl;
	}

	return 1;
}

int StartLoop()
{
	SafeGetInt();

	int iID = -1;
	int iChannel = -1;
	int iPos  = -1;

	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();
	cout<<"Channel:"<<endl;
	//cin>>iChannel;
	iChannel = SafeGetInt();
	cout<<"Picture no."<<endl;
	//cin>>iPos;
	iPos = SafeGetInt();

	if (pClsNVD->DEC_ClientGetLoopStatus(iID,iChannel,iPos))
	{
		cout<<"Can not start it again!"<<endl;
		return -1;
	}
	
	int iRet = pClsNVD->DEC_ClientStartLoop(iID,iChannel,iPos);
	if (iRet < 0)
	{
		cout<<"Startloop failed:"<<iRet<<endl;
		return iRet;
	}
	
	cout<<"Loop started!.."<<endl;

	return 1;
}

int StopLoop()
{
	SafeGetInt();

	int iID = -1;
	int iChannel = -1;
	int iPos  = -1;

	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();
	cout<<"Channel:"<<endl;
	//cin>>iChannel;
	iChannel = SafeGetInt();
	cout<<"Picture no."<<endl;
	//cin>>iPos;
	iPos = SafeGetInt();

	if (!pClsNVD->DEC_ClientGetLoopStatus(iID,iChannel,iPos))
	{
		cout<<"Can not stop it again!"<<endl;
		return -1;
	}

	int iRet = pClsNVD->DEC_ClientStopLoop(iID,iChannel,iPos);
	if (iRet < 0)
	{
		cout<<"Stoploop failed:"<<iRet<<endl;
		return iRet;
	}
	
	cout<<"Loop stoped!.."<<endl;
	return 1;
}


int AddNVS()
{
	SafeGetInt();

	int iID = -1;
	int iChannel = -1;
	int iPos  = -1;
	char strSerIP[33] = {0};
	char strSerName[33] = {0};
	//structֵ
	TNVSITEMEX nvsItemEx;
	memset(&nvsItemEx, 0, sizeof(TNVSITEMEX));
	nvsItemEx.m_iStructLen = sizeof(TNVSITEMEX);

	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();
	cout<<"Channel:"<<endl;
	//cin>>iChannel;
	iChannel = SafeGetInt();
	cout<<"Picture no."<<endl;
	//cin>>iPos;
	iPos = SafeGetInt();
	
	cout<<"Please select mode:(ip:0,ddns:1,active:2)"<<endl;
	int iMode = -1;
	//cin>>iMode;
	iMode = SafeGetInt();
	if (0 == iMode)
	{
		cout<<"Server IP:"<<endl;
		//cin>>strSerIP;
		gets_s(strSerIP, DEC_LEN_32);
		strcpy(nvsItemEx.m_stOldItem.m_serIP,strSerIP);
	}
	else if (1 == iMode)
	{
		cout<<"Server name:"<<endl;
		//cin>>strSerName;
		gets_s(strSerName, DEC_LEN_32);
		strcpy(nvsItemEx.m_stOldItem.m_serName,strSerName);
		nvsItemEx.m_stOldItem.m_bUseddns = 1;
	}
	else if (2 == iMode)
	{
		cout<<"Server name:"<<endl;
		//cin>>strSerName;
		gets_s(strSerName, DEC_LEN_32);
		strcpy(nvsItemEx.m_stOldItem.m_serName,strSerName);
		nvsItemEx.m_stOldItem.m_bUseddns = 1;
	}

	cout<<"Channel:"<<endl;
	int iChan = -1;
	//cin>>iChan;
	iChan = SafeGetInt();
	cout<<"Stream:(main:0,sub:1)"<<endl;
	int iStream = -1;
	//cin>>iStream;
	iStream = SafeGetInt();
	cout<<"Net Mode:(TCP:1,UDP:2,MU:3)"<<endl;
	int iNetMode = -1;
	//cin>>iNetMode;
	iNetMode = SafeGetInt();
	cout<<"Hold Time:(10~1000)"<<endl;
	int iHoldTime = -1;
	//cin>>iHoldTime;
	iHoldTime = SafeGetInt();
	cout<<"Proxy IP:(Input \"NULL\" to set proxyip NULL.)"<<endl;
	char* strProxyIP = new char[17];
	memset(strProxyIP, 0, 17);
	//cin>>strProxyIP;
	gets_s(strProxyIP, DEC_LEN_16);
	if(0 != strcmp(strProxyIP, ""))
	{
		strcpy(nvsItemEx.m_stOldItem.m_serProxy,strProxyIP);	
	}

	cout<<"Port:(70~45000)"<<endl;
	int iPort = -1;
	//cin>>iPort;
	iPort = SafeGetInt();
	
	char		   	strUsername[20] = {0};		//û
	char	       	strPassword[20] = {0};		//
	char            strDeviceType[16] = {0};   //豸Э飨Ҫ뵽Э飩
	//unsigned char   ucAddress = 0;         //NVS豸ַȡֵΧ0-255
	int				iAddress = 0;

	cout<<"User name:"<<endl;
	//cin>>strUsername;
	gets_s(strUsername, 20);
	cout<<"Password:"<<endl;
	//cin>>strPassword;
	gets_s(strPassword, 20);
	cout<<"Device type:(DOME_PELCO_D or DOME_PELCO_P or DOME_TIANDY)"<<endl;
	//cin>>strDeviceType;
	gets_s(strDeviceType, 16);
	cout<<"NVS address:(0~255)"<<endl;
	//cin>>iAddress;
	iAddress = SafeGetInt();
	cout<<"iAddress="<<iAddress<<endl;

	nvsItemEx.m_stOldItem.m_serChan = iChan;
	nvsItemEx.m_stOldItem.m_serStream = iStream;
	nvsItemEx.m_stOldItem.m_serNetmode = iNetMode;

	nvsItemEx.m_stOldItem.m_holdtime = iHoldTime;
	nvsItemEx.m_stOldItem.m_serPort = iPort;
	strcpy(nvsItemEx.m_stOldItem.m_username, strUsername);
	strcpy(nvsItemEx.m_stOldItem.m_password, strPassword);
	strcpy(nvsItemEx.m_stOldItem.m_deviceType, strDeviceType);
	iAddress -= 1;	//ַǰ豸ĿƵַõʱ1
	nvsItemEx.m_stOldItem.m_iAddress = iAddress;

	char  strEncryptPWD[MAX_ENCYPTPWD_LEN] = {0};		//
	int   iDevPlatType = 0;
	cout<<"Encrpyt password:(Input \"NULL\" to set pwd NULL.)"<<endl;
	//cin>>strEncryptPWD;
	gets_s(strEncryptPWD, MAX_ENCYPTPWD_LEN);
	if(0 == strcasecmp(strEncryptPWD, "null"))
		memset(strEncryptPWD, 0, sizeof(strEncryptPWD));

	cout<<"Device type(0-nomarl, 1-onvif, 3-RTSP):"<<endl;
	//cin>>iDevPlatType;
	iDevPlatType = SafeGetInt();
	if (3 == iDevPlatType)
	{
		char RTSPAddr[79] = {0};
		cout<<"RTSP Address:"<<endl;
		//cin>>RTSPAddr;
		gets_s(RTSPAddr, 79);
		strcpy(nvsItemEx.m_stOldItem.m_cRTSPUrl,RTSPAddr);
	}
	
	strcpy(nvsItemEx.m_cEncyptPWD, strEncryptPWD);
	nvsItemEx.m_iDevPlatType = iDevPlatType;

	char cMultIp[33] = {0};
	cout<<"Mult Address:"<<endl;
	gets_s(cMultIp, 79);
	strcpy(nvsItemEx.m_cMultIP, cMultIp);
	cout<<"Mult Port:"<<endl;
	nvsItemEx.m_iMultPort = SafeGetInt();


	for (int i=0; i<MAX_NVSNUM; i++)
	{
		if (!g_pNvsArr[i])
		{
			g_pNvsArr[i] = new NVSINFO();
			g_pNvsArr[i]->m_iDecID = iID;
			g_pNvsArr[i]->m_iChan = iChannel;
			g_pNvsArr[i]->m_iPic = iPos;
			memcpy(&(g_pNvsArr[i]->m_viewItemEx), &nvsItemEx, sizeof(TNVSITEMEX));
		}
	}

	int iRet = -1;
	int iIndex = -1;
	iIndex = pClsNVD->DEC_ClientGetLoopItemCount(iID, iChannel, iPos);
	if (iIndex >= 0)
	{
		iRet = pClsNVD->DEC_ClientSetLoopItemEx(iID, iIndex, &nvsItemEx, iChannel, iPos);
		if (iRet < 0)
		{
			cout<<"Add failed, ret = "<<iRet<<endl;
			return iRet;
		}
	}

	return 1;
}

int DelNVS(int _iID, int _iChannel, int _iPos, int _iNVSIndex)
{
	SafeGetInt();

	int iID = -1;
	int iChannel = -1;
	int iPos  = -1;
	int iNVSIndex = -1;

	if (-1 == _iID || -1 == _iChannel || -1 == _iPos || -1 == _iNVSIndex)
	{
		cout<<"Please specify decorder id:"<<endl;
		//cin>>iID;
		iID = SafeGetInt();
		cout<<"Channel:"<<endl;
		//cin>>iChannel;
		iChannel = SafeGetInt();
		cout<<"Picture no."<<endl;
		//cin>>iPos;
		iPos = SafeGetInt();
		cout<<"Please specify nvs index:"<<endl;
		//cin>>iNVSIndex;
		iNVSIndex = SafeGetInt();
	}
	else
	{
		iID = _iID;
		iChannel = _iChannel;
		iPos = _iPos;
		iNVSIndex = _iNVSIndex;
	}
	
	if (pClsNVD->DEC_ClientGetLoopStatus(iID,iChannel,iPos))
	{
		cout<<"Can't delete it when looping.."<<endl;
		return -1;
	}
	
	int iRet = -1;
	iRet = pClsNVD->DEC_ClientDelLoopItem(iID, iNVSIndex, iChannel, iPos);
	if (iRet < 0)
	{
		cout<<"Delete failed! Return:"<<iRet<<endl;
		return iRet;
	}
	
	delete g_pNvsArr[iNVSIndex];
	g_pNvsArr[iNVSIndex] = NULL;

	return 1;
}

int StartAudio()
{
	SafeGetInt();
	int iID = -1;
	int iChannel = -1;
	int iPos  = -1;

	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();
	cout<<"Channel:"<<endl;
	//cin>>iChannel;
	iChannel = SafeGetInt();
	cout<<"Picture no."<<endl;
	//cin>>iPos;
	iPos = SafeGetInt();
	
	TNVSITEM nvsitem;
	int iRet;
	if ((iRet = pClsNVD->DEC_ClientGetViewItem(iID,&nvsitem,iChannel,iPos)) < 0)
	{
		cout<<"Now,there is no video.."<<endl;
		return iRet;
	}
	
	iRet = pClsNVD->DEC_ClientGetAudioStatus(iID,iChannel,iPos);
	if (iRet < 0 || iRet)
	{
		cout<<"Common error or has started.."<<endl;
		return -1;
	}

	iRet = pClsNVD->DEC_ClientSoundCtrl(iID, 1, iChannel, iPos);
	if (iRet < 0)
	{
		cout<<"[StartAudio::DEC_ClientSoundCtrl]fail!"<<iRet<<endl;
		return iRet;
	}
	else 
	{
		m_VecDecoder[iID].m_stPush[iChannel][iPos].m_bFlagAudio = true;
	}

	return 1;
}

int StopAudio()
{
	SafeGetInt();

	int iID = -1;
	int iChannel = -1;
	int iPos  = -1;

	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();
	cout<<"Channel:"<<endl;
	//cin>>iChannel;
	iChannel = SafeGetInt();
	cout<<"Picture no."<<endl;
	//cin>>iPos;
	iPos = SafeGetInt();

	TNVSITEM nvsitem;
	int iRet;
	if ((iRet = pClsNVD->DEC_ClientGetViewItem(iID,&nvsitem,iChannel,iPos)) < 0)
	{
		cout<<"Now,there is no video.."<<endl;
		return iRet;
	}
	
	iRet = pClsNVD->DEC_ClientGetAudioStatus(iID,iChannel,iPos);
	if (iRet < 0 || !iRet)
	{
		cout<<"Common error or has stoped.."<<endl;
		return iRet;
	}

	iRet = pClsNVD->DEC_ClientSoundCtrl(iID, 0, iChannel, iPos);
	if (iRet < 0)
	{
		cout<<"[StartAudio::DEC_ClientSoundCtrl]fail!"<<iRet<<endl;
		return iRet;
	}
	else
	{
		m_VecDecoder[iID].m_stPush[iChannel][iPos].m_bFlagAudio = false;
	}

	return 1;
}

int PTZCtrl()
{
	cout<<"Please input direction(left or right):"<<endl;
	string strDiret;
	cin>>strDiret;

	switch (g_mpCmd[strDiret])
	{
	case 41:
		break;
	case 42:
		break;
	}
	return 1;
}

int DEC485Ctrl()
{
	SafeGetInt();

	int iID = -1;
	int iChannel = -1;
	int iPos  = -1;

	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();
	cout<<"Channel:"<<endl;
	//cin>>iChannel;
	iChannel = SafeGetInt();
	cout<<"Picture no."<<endl;
	//cin>>iPos;
	iPos = SafeGetInt();

	cout<<"Please input direction(left or up):"<<endl;
	string strDiret;
	cin>>strDiret;
	Data_t m_data;
	memset(&m_data,0,sizeof(Data_t));
	int iRet = -1;

	switch (g_mpCmd[string(strDiret)])
	{
	case 41:
		m_data.point.x = -50;
		m_data.point.y = 0;
		if (!GetControlCode(MOVE,&m_data))
		{
			cout<<"Get control code failed"<<endl;
			return 0;
		}
		cout<<"Input 'z' to stop."<<endl;
		iRet = pClsNVD->DEC_Client485Send(iID,m_data.DecBuf,m_data.iCount,iChannel,iPos);
		if (iRet < 0)
		{
			cout<<"Control failed, ret = "<<iRet<<endl;
		}
		break;
	case 42:
		m_data.point.x = 0;
		m_data.point.y = 50;
		if (!GetControlCode(MOVE,&m_data))
		{
			cout<<"Get control code failed"<<endl;
			return 0;
		}
		iRet = pClsNVD->DEC_Client485Send(iID,m_data.DecBuf,m_data.iCount,iChannel,iPos);
		if (iRet < 0)
		{
			cout<<"Control failed"<<endl;
		}
		break;
	}
	
	GetControlCode(MOVE_STOP,&m_data);
	pClsNVD->DEC_Client485Send(iID,m_data.DecBuf,m_data.iCount,iChannel,iPos);

	return 1;
}

int StartTalk()
{
	SafeGetInt();

	int iID = -1;
	int iChannel = -1;
	int iPos  = -1;

	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();
	cout<<"Channel:"<<endl;
	//cin>>iChannel;
	iChannel = SafeGetInt();
	cout<<"Picture no."<<endl;
	//cin>>iPos;
	iPos = SafeGetInt();

	TNVSITEM nvsitem;
	int iRet;
	if ((iRet = pClsNVD->DEC_ClientGetViewItem(iID,&nvsitem,iChannel,iPos)) < 0)
	{
		cout<<"Now,there is no video.."<<endl;
		return iRet;
	}

	if (pClsNVD->DEC_ClientGetLoopStatus(iID,iChannel,iPos))
	{
		cout<<"Can't control when it is looping!..";
		return -1;
	}

	iRet = pClsNVD->DEC_ClientGetTalkStatus(iID,iChannel,iPos);
	if (iRet < 0 || iRet == 1)
	{
		cout<<"Common error or has started!.."<<endl;
		return iRet;
	}
	
	iRet = pClsNVD->DEC_ClientTalkServer(iID, 1, iChannel, iPos);
	if (iRet < 0)
	{
		cout<<"Start error"<<endl;
		return iRet;
	}

	cout<<"Start talk.."<<endl;

	return 1;
}

int StopTalk()
{
	SafeGetInt();
	int iID = -1;
	int iChannel = -1;
	int iPos  = -1;

	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();
	cout<<"Channel:"<<endl;
	//cin>>iChannel;
	iChannel = SafeGetInt();
	cout<<"Picture no."<<endl;
	//cin>>iPos;
	iPos = SafeGetInt();

	TNVSITEM nvsitem;
	int iRet;
	if ((iRet = pClsNVD->DEC_ClientGetViewItem(iID,&nvsitem,iChannel,iPos)) < 0)
	{
		cout<<"Now,there is no video.."<<endl;
		return iRet;
	}

	if (pClsNVD->DEC_ClientGetLoopStatus(iID,iChannel,iPos))
	{
		cout<<"Can't control when it is looping!..";
		return -1;
	}

	iRet = pClsNVD->DEC_ClientGetTalkStatus(iID,iChannel,iPos);
	if (iRet < 0 || iRet == 0)
	{
		cout<<"Common error or has stoped!.."<<endl;
		return iRet;
	}
	
	iRet = pClsNVD->DEC_ClientTalkServer(iID, 0, iChannel, iPos);
	if (iRet < 0)
	{
		cout<<"Stop error"<<endl;
		return iRet;
	}

	cout<<"Stop talk.."<<endl;

	return 1;
}

int RebootDec(int _iID)
{
	int iID = -1;
	if (-1 == _iID)
	{
		SafeGetInt();
		cout<<"Specify decoder id:"<<endl;
		//cin>>iID;
		iID = SafeGetInt();
	}
	else
	{
		iID = _iID;
	}	

	int iRet = pClsNVD->DEC_ClientRebootDecoder(iID);

	if (iRet < 0)
	{
		cout<<"Reboot failed!"<<endl;
		return iRet;
	}
	
	cout<<"Rebooting ....Please reconnect later!"<<endl;
	return 1;
}

int ResetDec(int _iID)
{
	SafeGetInt();
	int iID = -1;

	cout<<"Confirm?yes:1,no:0"<<endl<<">";

	int iRest = -1;
	//cin>>iRest;
	iRest = SafeGetInt();
	if (1 == iRest)
	{
		if (-1 == _iID)
		{
			cout<<"Specify decoder id:"<<endl;
			//cin>>iID;
			iID = SafeGetInt();
		}
		else
		{
			iID = _iID;
		}

		int iRet = pClsNVD->DEC_ClientResetDefault(iID);

		if (iRet < 0)
		{
			cout<<"Reboot failed!"<<endl;
			return iRet;
		}
		cout<<"ReSeting ....Please reconnect later!"<<endl;
	}
	

	return 1;
}

int UpgradeKernel()
{
	SafeGetInt();
	cout<<"This function must be used by special people who is familiar with the device, or there will be a serious result!,Confirm?yes:1,no:0"<<endl;

	int iUp = -1;
	//cin>>iUp;
	iUp = SafeGetInt();
	if (1 == iUp)
	{
		cout<<"Please specify decoder id:"<<endl;
		int iID = -1;
		//cin>>iID;
		iID = SafeGetInt();
		cout<<"Specify kernel file(*.bin) path(absolute):"<<endl;
		string strKerPath;
		cin>>strKerPath;

		int iRet = pClsNVD->DEC_ClientUpgrade(iID,(char*)strKerPath.c_str());

		if (iRet < 0)
		{
			cout<<"Upgrade failed"<<endl;
			return iRet;
		}
	}

	return 1;
}

int UpgradeLogo()
{
	SafeGetInt();
	cout<<"This function must be used by special people who is familiar with the device, or there will be a serious result!,Confirm?yes:1,no:0"<<endl;

	int iUp = -1;
	//cin>>iUp;
	iUp = SafeGetInt();
	if (1 == iUp)
	{
		cout<<"Please specify decoder id:"<<endl;
		int iID = -1;
		//cin>>iID;
		iID = SafeGetInt();
		cout<<"Specify logo picture path(absolute):"<<endl;
		string strLogoPath;
		cin>>strLogoPath;

		int iRet = pClsNVD->DEC_ClientUpgradeLogo(iID,(char*)strLogoPath.c_str());

		if (iRet < 0)
		{
			cout<<"Upgrade failed,iRet="<<iRet<<endl;
			return iRet;
		}
	}

	return 1;
}

int UpgradeProtocol()
{
	SafeGetInt();
	cout<<"This function must be used by special people who is familiar with the device, or there will be a serious result!,Confirm?yes:1,no:0"<<endl;

	int iUp = -1;
	//cin>>iUp;
	iUp = SafeGetInt();
	if (1 == iUp)
	{
		cout<<"Please specify decoder id:"<<endl;
		int iID = -1;
		//cin>>iID;
		iID = SafeGetInt();
//  	cout<<"Specify protocol file path(absolute):"<<endl;
//  	string strProtPath;
//  	cin>>strProtPath;
		
		cout<<"Specify protocol file(*.so) name(absolute):"<<endl;
		string strProtName;
		cin>>strProtName;

		//int iRet = pClsNVD->DEC_ClientUpgradeProtocol(iID,(char*)strProtPath.c_str(),(char*)strProtName.c_str());
		int iRet = pClsNVD->DEC_ClientUpgradeProtocol(iID, (char*)"protocol", (char*)strProtName.c_str());
		if (iRet < 0)
		{
			cout<<"Upgrade failed"<<endl;
			return iRet;
		}
	}

	return 1;
}

int UpgradeWeb()
{
	SafeGetInt();
	cout<<"This function must be used by special people who is familiar with the device, or there will be a serious result!,Confirm?yes:1,no:0"<<endl;

	int iUp = -1;
	//cin>>iUp;
	iUp = SafeGetInt();
	if (1 == iUp)
	{
		cout<<"Please specify decoder id:"<<endl;
		int iID = -1;
		//cin>>iID;
		iID = SafeGetInt();
		cout<<"Specify file(*.box) path(absolute):"<<endl;
		string strProtPath;
		cin>>strProtPath;

		int iRet = pClsNVD->DEC_ClientUpgradeWeb(iID,(char*)strProtPath.c_str());

		if (iRet < 0)
		{
			cout<<"Upgrade failed"<<endl;
		}
	}

	return 1;
}


int DeleteProtocol()
{
	SafeGetInt();
	cout<<"This function must be used by special people who is familiar with the device, or there will be a serious result!,Confirm?yes:1,no:0"<<endl;

	int iUp = -1;
	//cin>>iUp;
	iUp = SafeGetInt();
	if (1 == iUp)
	{
		cout<<"Please specify decoder id:"<<endl;
		int iID = -1;
		//cin>>iID;
		iID = SafeGetInt();
		cout<<"Specify protocol name:"<<endl;
		string strProtName;
		cin>>strProtName;

		int iRet = pClsNVD->DEC_ClientDeleteProtocol(iID,(char*)strProtName.c_str());

		if (iRet < 0)
		{
			cout<<"Delete protocol failed"<<endl;
			return iRet;
		}
	}

	return 1;
}

//add by-->wangshaobo20121120
void* threadPushStreamToDecoder(void* _pvPara)
{
	st_PushStream* pstPush = (st_PushStream*)_pvPara;

	while(!g_bStopSendThread)
	{
		if(pstPush->m_bStart == 1)
		{
			if(pstPush->m_pFile && !feof(pstPush->m_pFile))
			{
				int iBufState = 0;
				pClsNVD->procDEC_ClientGetStreamBufferState(pstPush->m_lPushID, &iBufState);
				if((RET_BUFFER_FULL == iBufState) || (RET_BUFFER_WILL_BE_FULL == iBufState))
				{
					usleep(1000);
					continue;
				}

				char cDataBuf[MAX_PUSH_STREAM_LEN] = {0};
				int iRet = fread(cDataBuf, sizeof(char), MAX_PUSH_STREAM_LEN, pstPush->m_pFile);
				iRet = pClsNVD->DEC_ClientSendStream(pstPush->m_lPushID, iRet, cDataBuf);
				if ((pstPush->m_pFile)&&feof(pstPush->m_pFile))
				{
					fseek(pstPush->m_pFile, sizeof(S_header), SEEK_SET);
				}
			}
		}
		else
		{
			fprintf(stderr, "=================Thread quit here...\n");
			return NULL;
		}
	}

	return NULL;
}

int StartPushStream()
{
	SafeGetInt();
	int iID = -1;
	int iChannel = -1;
	int iPushID = -1;
	int iPos = -1;

	int iCmdValue = PUSH_PLAYBACK_STREAM_PLAY;

	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();
	cout<<"Channel:"<<endl;
	//cin>>iChannel;
	iChannel = SafeGetInt();
	cout<<"Picture no."<<endl;
	//cin>>iPos;
	iPos = SafeGetInt();
	
	if (m_VecDecoder[iID].m_stPush[iChannel][iPos].m_bStart == 1)
	{
		cout<<"Already pushing ........."<<endl;
	}
	else
	{
		string FileName;
		cout<<"Please specify SDV file(*.sdv):"<<endl;

		cin>>FileName;

		pFile = fopen(FileName.c_str(),"rb");
		if(NULL == pFile)
		{
			cout<<"Open file failed!!!"<<endl;
			return 1;
		}
		S_header fileHeader;
		fread(&fileHeader,sizeof(char),sizeof(S_header),pFile);
		//ļݿ͸߻ƵСʵʹǲ
		int iVideoSize = VIDEO_FD1;
		iVideoSize = CalculateVideoSize(&fileHeader);
		iPushID = pClsNVD->DEC_ClientStartPushStream(iID, iChannel, iPos, 0, iVideoSize);
		//iPushID = pClsNVD->procDEC_ClientConfigStreamInfo(iID, iChannel, iPos,CONF_CMD_VIDEOHEAD, &fileHeader, sizeof(S_header));
		if(iPushID >= 0)
		{
			int iRet = pClsNVD->procDEC_ClientStreamControl(iPushID, PUSH_STREAM_CMD_PAUSE, &iCmdValue, sizeof(int));//ע˴Ҫ
			//pClsNVD->DEC_ClientStopPushStream(iPushID);
			//int iRet = pClsNVD->procDEC_ClientConfigStreamInfo(iID, iChannel, iPos,CONF_CMD_VIDEOHEAD, &fileHeader, sizeof(S_header));
			//pClsNVD->procDEC_ClientStreamControl(iPushID, PUSH_STREAM_CMD_PAUSE, &iCmdValue, sizeof(int));
			cout<<"[StartPushStream--procDEC_ClientConfigStreamInfo]Return value="<<iRet
				<<"iVideoSize="<<iVideoSize<<endl;
			if(m_VecDecoder[iID].m_stPush[iChannel][iPos].m_pFile)
			{
				cout<<"File is opened!!!"<<endl;
			}
			m_VecDecoder[iID].m_stPush[iChannel][iPos].m_lPushID = iPushID;
			m_VecDecoder[iID].m_stPush[iChannel][iPos].m_pFile = pFile;
			m_VecDecoder[iID].m_stPush[iChannel][iPos].m_bStart = 1;
		}

		pthread_t tdSend = 0;
		//ط
		int iRet = pthread_create(&tdSend, NULL, threadPushStreamToDecoder, &m_VecDecoder[iID].m_stPush[iChannel][iPos]);
		//pthread_detach(tdSend);
		//ʵʱ
		//int iRet = pthread_create(&tdSend, NULL, threadPushStream, NULL);
		if(iRet != 0)
			cout<<"Create sendstream thread failed!"<<endl;
	}

	return 1;
}

int StopPushStream()
{
	SafeGetInt();
	int iID = -1;
	int iChannel = -1;
	int iPos = -1;
	int iShowLastPic= -1;

	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();
	cout<<"Channel:"<<endl;
	//cin>>iChannel;
	iChannel = SafeGetInt();
	cout<<"Picture no."<<endl;
	//cin>>iPos;
	iPos = SafeGetInt();
	cout<<"if save last frame? -1-->ignore;0-->no;1-->yes."<<endl;
	//cin>>iShowLastPic;
	iShowLastPic = SafeGetInt();

	if (m_VecDecoder[iID].m_stPush[iChannel][iPos].m_bStart == 0)
	{
		cout<<"No pushing .."<<endl;
	}
	else
	{
		int iRet = -1;
		if (m_VecDecoder[iID].m_stPush[iChannel][iPos].m_bStart == 1)
		{
			if(-1 == iShowLastPic)
			{
				iRet = pClsNVD->DEC_ClientStopPushStream(m_VecDecoder[iID].m_stPush[iChannel][iPos].m_lPushID);
			}
			else if(0 == iShowLastPic || 1 == iShowLastPic)
			{
				iRet = pClsNVD->procDEC_ClientStopPushStreamEx(m_VecDecoder[iID].m_stPush[iChannel][iPos].m_lPushID,iShowLastPic);
			}
			
			m_VecDecoder[iID].m_stPush[iChannel][iPos].m_bStart = 0;
			usleep(500*1000);
			if(m_VecDecoder[iID].m_stPush[iChannel][iPos].m_pFile != NULL)
			{
				fclose(m_VecDecoder[iID].m_stPush[iChannel][iPos].m_pFile);
				m_VecDecoder[iID].m_stPush[iChannel][iPos].m_pFile = NULL;
			}
		}

		if (iRet < 0)
		{
			cout<<"Stop push failed! Return:"<<iRet<<endl;
			return iRet;
		}

		cout<<"Stop success!"<<endl;
	}

	return 1;
}

int GetCapability(int _iID)
{
	int iID;
	if (-1 == _iID)
	{
		SafeGetInt();
		cout<<"Please specify decoder id:"<<endl;
		//cin>>iID;
		iID = SafeGetInt();
	}
	else
	{
		iID = _iID;
	}

	char cCap[64] = {0};
	int iRet = 0;
	iRet = pClsNVD->DEC_ClientGetCapability(iID,cCap);
	if (iRet < 0)
	{
		cout<<"Get failed!... return:"<<iRet<<endl;
		return iRet;
	}

	cout<<"Decoder Capability:"<<cCap<<endl;

	return 1;
}

int RecordNVSInfo()
{
	SafeGetInt();

	int iID = -1;
	int iChan = -1;
	int iPos = -1;
	cout<<"Decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();
	cout<<"Decorder channel:"<<endl;
	//cin>>iChan;
	iChan = SafeGetInt();
	cout<<"Picture no."<<endl;
	//cin>>iPos;
	iPos = SafeGetInt();

	TNVSITEMEX nvsItemEx = {0};
	nvsItemEx.m_iStructLen = sizeof(TNVSITEMEX);

	int iItemNum = -1;
	//cout<<iID<<iChan<<iPos<<endl;
	iItemNum = pClsNVD->DEC_ClientGetLoopItemCount(iID,iChan,iPos);

	if (iItemNum < 0)
	{
		cout<<"Check channel or Picture no. Return:"<<iItemNum<<endl;
		return iItemNum;
	}
	
	for (int i=0; i<iItemNum; i++)
	{
		nvsItemEx.m_iStructLen = sizeof(TNVSITEMEX);
		int iRet = pClsNVD->DEC_ClientGetLoopItemEx(iID, i, &nvsItemEx, iChan, iPos);
		if (iRet < 0)
		{
			cout<<"GetLoop failed!Return"<<iRet<<endl;
			return -2;
		}
		if (!g_pNvsArr[i])
		{
			g_pNvsArr[i] = new NVSINFO();
			g_pNvsArr[i]->m_iDecID = iID;
			g_pNvsArr[i]->m_iChan = iChan;
			g_pNvsArr[i]->m_iPic = iPos;
			memcpy(&(g_pNvsArr[i]->m_viewItemEx), &nvsItemEx, sizeof(TNVSITEMEX));
			//break;
		}				
	}

	ShowNVSInfo(iID, iChan, iPos);

	return 1;
}

int ModifyNVS()
{
	SafeGetInt();
	int iID = -1;
	int iChannel = -1;
	int iPos  = -1;
	char strSerIP[33] = {0};
	char strSerName[33] = {0};
	//structֵ
	TNVSITEMEX nvsItemEx;
	memset(&nvsItemEx, 0, sizeof(TNVSITEMEX));
	nvsItemEx.m_iStructLen = sizeof(TNVSITEMEX);

	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();
	cout<<"Channel:"<<endl;
	//cin>>iChannel;
	iChannel = SafeGetInt();
	cout<<"Picture no."<<endl;
	//cin>>iPos;
	iPos = SafeGetInt();
	
	cout<<"Please specify the nvs index which you want to modify:"<<endl;

	int iIndex = -1;
	//cin>>iIndex;
	iIndex = SafeGetInt();

	if (NULL == g_pNvsArr[iIndex])
	{
		cout<<"NVS not exist!"<<endl;
		return -1;
	}

	cout<<"Please select mode:(ip:0,ddns:1,active:2)"<<endl;
	int iMode = -1;
	//cin>>iMode;
	iMode = SafeGetInt();
	if (0 == iMode)
	{
		cout<<"Server IP:"<<endl;
		//cin>>strSerIP;
		gets_s(strSerIP, 33);
		strcpy(nvsItemEx.m_stOldItem.m_serIP,strSerIP);
	}
	else if (1 == iMode)
	{
		cout<<"Server name:"<<endl;
		//cin>>strSerName;
		gets_s(strSerName, 33);
		strcpy(nvsItemEx.m_stOldItem.m_serName,strSerName);
	}
	else if (2 == iMode)
	{
		cout<<"Server name:"<<endl;
		//cin>>strSerName;
		gets_s(strSerName, 33);
		strcpy(nvsItemEx.m_stOldItem.m_serName,strSerName);
	}

	cout<<"Channel:"<<endl;
	int iChan = -1;
	//cin>>iChan;
	iChan = SafeGetInt();
	cout<<"Stream:(main:0,sub:1)"<<endl;
	int iStream = -1;
	//cin>>iStream;
	iStream = SafeGetInt();
	cout<<"Net Mode:(TCP:1,UDP:2,MU:3)"<<endl;
	int iNetMode = -1;
	//cin>>iNetMode;
	iNetMode = SafeGetInt();
	cout<<"Hold Time:(10~1000)"<<endl;
	int iHoldTime = -1;
	//cin>>iHoldTime;
	iHoldTime = SafeGetInt();

	cout<<"Proxy IP:(Input \"NULL\" to set proxyip NULL.)"<<endl;
	char* strProxyIP = new char[17];
	memset(strProxyIP, 0, 17);
	//cin>>strProxyIP;
	gets_s(strProxyIP, 17);
	if(0 != strcmp(strProxyIP, ""))
	{
		strcpy(nvsItemEx.m_stOldItem.m_serProxy,strProxyIP);	
	}

	cout<<"Port:(70~45000)"<<endl;
	int iPort = -1;
	//cin>>iPort;
	iPort = SafeGetInt();

	char		   	strUsername[20] = {0};		//û
	char	       	strPassword[20] = {0};		//
	char            strDeviceType[16] = {0};   //豸Э飨Ҫ뵽Э飩
	int   			iAddress = 0;         //NVS豸ַȡֵΧ0-255

	cout<<"User name:"<<endl;
	//cin>>strUsername;
	gets_s(strUsername, 20);
	cout<<"Password:"<<endl;
	//cin>>strPassword;
	gets_s(strPassword, 20);
	cout<<"Device type:(DOME_PELCO_D or DOME_PELCO_P or DOME_TIANDY)"<<endl;
	//cin>>strDeviceType;
	gets_s(strDeviceType, 16);
	cout<<"NVS address:(0~255)"<<endl;
	//cin>>iAddress;
	iAddress = SafeGetInt();
	iAddress -= 1;	//ַǰ豸ĿƵַõʱ1

	nvsItemEx.m_stOldItem.m_serChan = iChan;
	nvsItemEx.m_stOldItem.m_serStream = iStream;
	nvsItemEx.m_stOldItem.m_serNetmode = iNetMode;

	nvsItemEx.m_stOldItem.m_holdtime = iHoldTime;
	nvsItemEx.m_stOldItem.m_serPort = iPort;
	strcpy(nvsItemEx.m_stOldItem.m_username, strUsername);
	strcpy(nvsItemEx.m_stOldItem.m_password, strPassword);
	strcpy(nvsItemEx.m_stOldItem.m_deviceType, strDeviceType);
	nvsItemEx.m_stOldItem.m_iAddress = iAddress;

	int   iDevPlatType = 0;
	char  strEncryptPWD[MAX_ENCYPTPWD_LEN] = {0};		//
	cout<<"Encrpyt password:(Input \"NULL\" to set pwd NULL.)"<<endl;
	//cin>>strEncryptPWD;
	gets_s(strEncryptPWD, 16);
	if(0 == strcasecmp(strEncryptPWD, "null"))
		memset(strEncryptPWD, 0, sizeof(strEncryptPWD));

	cout<<"Device type(0-nomarl, 1-onvif, 3-RTSP):"<<endl;
	//cin>>iDevPlatType;
	iDevPlatType = SafeGetInt();
	if (3 == iDevPlatType)
	{
		char RTSPAddr[79] = {0};
		cout<<"RTSP Address:"<<endl;
		//cin>>RTSPAddr;
		gets_s(RTSPAddr, 79);
		strcpy(nvsItemEx.m_stOldItem.m_cRTSPUrl,RTSPAddr);
	}

	strcpy(nvsItemEx.m_cEncyptPWD, strEncryptPWD);
	nvsItemEx.m_iDevPlatType = iDevPlatType;

	g_pNvsArr[iIndex]->m_iDecID = iID;
	g_pNvsArr[iIndex]->m_iChan = iChan;
	g_pNvsArr[iIndex]->m_iPic = iPos;
	memcpy(&(g_pNvsArr[iIndex]->m_viewItemEx), &nvsItemEx, sizeof(TNVSITEMEX));

	int iRet = -1;
	if (iIndex >= 0)
	{
		iRet = pClsNVD->DEC_ClientSetLoopItemEx(iID, iIndex, &nvsItemEx, iChannel, iPos);
		if (iRet < 0)
		{
			cout<<"Modify failed!iRet="<<iRet<<endl;
			return iRet;
		}
	}

	return 1;
}

int ListProtocol()
{
	SafeGetInt();
	int iID = -1;
	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();

	//TDECPROTOCOL protocol;
	//memset(&protocol,0,sizeof(TDECPROTOCOL));
	TDECPROTOCOL_EX tProtocolEx = {0};
	int iRet = pClsNVD->procDEC_ClientGetDevConfig(iID, 0, 0, CMD_DEC_CFG_PROTOCOL, &tProtocolEx, sizeof(TDECPROTOCOL_EX));
	if(iRet == 0)
	{
		for(int i=0; i<tProtocolEx.m_iCount; i++)
		{
			cout<<tProtocolEx.m_cProtocol[i]<<endl;
		}
	}

	return 1;
}

int GetStreamBufferState()
{
	SafeGetInt();
	int iID = 0;
	int iChannel = 0;
	int iPushID = -1;
	int iPos = 0;
	int iBufState = -1;

	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();
	cout<<"Channel:"<<endl;
	//cin>>iChannel;
	iChannel = SafeGetInt();
	cout<<"Picture no."<<endl;
	//cin>>iPos;
	iPos = SafeGetInt();

	iPushID = m_VecDecoder[iID].m_stPush[iChannel][iPos].m_lPushID; 
	if (iPushID < 0)
	{
		cout<<"not pushing stream!"<<endl;
		return -1;
	}
	int iRet = pClsNVD->procDEC_ClientGetStreamBufferState(iPushID, &iBufState);
	if (iRet < 0) 
	{
		ShowLog("[MSG]: GetStreamBuffState error......");
	}
	
	return 1;
}

int StreamControl()
{
	SafeGetInt();
	int iID = -1;
	int iChannel = -1;
	int iPushID = -1;
	int iPos = -1;
	int iCmd = -1;
	int iCmdValue = -1;
	int iValueLen = -1;

	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();
	cout<<"Channel:"<<endl;
	//cin>>iChannel;
	iChannel = SafeGetInt();
	cout<<"Picture no."<<endl;
	//cin>>iPos;
	iPos = SafeGetInt();
	cout<<"Cmd:"<<endl;
	//cin>>iCmd;
	iCmd = SafeGetInt();
	cout<<"CmdValue:"<<endl;
	//cin>>iCmdValue;
	iCmdValue = SafeGetInt();

	//int DEC_ClientStreamControl(int  _ulPushID, int  _iCmd, void* _pvCmdBuf, int _iCmdLen);
	/*	_iPushID			DEC_ClientStartPushStreamķֵ
				_iCmd		    	ʶĲָ0ͣ1ţ2
				*_pvCmdBuf			洢ֵָĿǰֲ֧
									<1>ָͣ1ͣ     0ָ
                                    <2>ָ0 1  2ı  3˱  4ʮ
                                    <3>ָ0 1  2ı  3˱ 4ʮ
				_iCmdLen			ֵָ洢ĳ*/


	iValueLen = sizeof(int);
	iPushID = m_VecDecoder[iID].m_stPush[iChannel][iPos].m_lPushID;
	if (iPushID < 0)
	{
		cout<<"not pushing stream!"<<endl;
		return -1;
	}
	if ( 1== iCmd && iCmdValue >4)
	{
		ShowLog("[MSG]: Fast speed < 4(X4)......");
		iCmdValue = 1;
	}
	int iRet = pClsNVD->procDEC_ClientStreamControl(iPushID, iCmd, &iCmdValue, iValueLen);
	if (iRet < 0) 
	{
		ShowLog("[MSG]: StreamControl error......");
	}
	if ((PUSH_STREAM_CMD_FAST == iCmd) && (iCmdValue >0) && true == m_VecDecoder[iID].m_stPush[iChannel][iPos].m_bFlagAudio)
	{
		pClsNVD->DEC_ClientSoundCtrl(iID,0,iChannel,iPos);
		cout<<"Close Auddio!"<<endl;
	}

	if ((PUSH_STREAM_CMD_FAST == iCmd) && (iCmdValue == 0) && (true == m_VecDecoder[iID].m_stPush[iChannel][iPos].m_bFlagAudio))
	{
		pClsNVD->DEC_ClientSoundCtrl(iID,1,iChannel,iPos);
		cout<<"Open Auddio!"<<endl;
	}
	
	if ((PUSH_STREAM_CMD_SLOW == iCmd) && (iCmdValue >0)  && (true == m_VecDecoder[iID].m_stPush[iChannel][iPos].m_bFlagAudio))
	{
		pClsNVD->DEC_ClientSoundCtrl(iID,0,iChannel,iPos);
		cout<<"Close Auddio!"<<endl;
	}

	if ((PUSH_STREAM_CMD_SLOW == iCmd) && (iCmdValue == 0) && (true == m_VecDecoder[iID].m_stPush[iChannel][iPos].m_bFlagAudio))
	{
		pClsNVD->DEC_ClientSoundCtrl(iID,1,iChannel,iPos);
		cout<<"Open Auddio!"<<endl;
	}		

	return 0;
}

//Ƶ
int ConnectAllPushVideo()
{
	int iPushID = -1;
	int iCmdValue = PUSH_PLAYBACK_STREAM_PLAY;
	for(unsigned int i=0;i<1;++i)
	{
		for(int j=0; j<1; ++j)
		{
			for(int k=0; k<9; ++k)
			{
				pFile = fopen("c.sdv","rb");
				if(NULL == pFile)
				{
					cout<<"Open file failed!!!"<<endl;
					return 1;
				}
				S_header fileHeader;
				fread(&fileHeader,sizeof(char),sizeof(S_header),pFile);
				//ļݿ͸߻ƵСʵʹǲ
				int iVideoSize = VIDEO_FD1;
				iVideoSize = CalculateVideoSize(&fileHeader);
				iPushID = pClsNVD->DEC_ClientStartPushStream(i, j, k, 0, iVideoSize);
				//iPushID = pClsNVD->procDEC_ClientConfigStreamInfo(iID, iChannel, iPos,CONF_CMD_VIDEOHEAD, &fileHeader, sizeof(S_header));
				if(iPushID >= 0)
				{
					pClsNVD->procDEC_ClientStreamControl(iPushID, PUSH_STREAM_CMD_PAUSE, &iCmdValue, sizeof(int));//ע˴Ҫ
					pClsNVD->DEC_ClientStopPushStream(iPushID);
					int iRet = pClsNVD->procDEC_ClientConfigStreamInfo(i, j, k,CONF_CMD_VIDEOHEAD, &fileHeader, sizeof(S_header));
					pClsNVD->procDEC_ClientStreamControl(iPushID, PUSH_STREAM_CMD_PAUSE, &iCmdValue, sizeof(int));
					cout<<"[StartPushStream--procDEC_ClientConfigStreamInfo]Return value="<<iRet
						<<"iVideoSize="<<iVideoSize<<endl;
					if(m_VecDecoder[i].m_stPush[j][k].m_pFile)
					{
						cout<<"File is opened!!!"<<endl;
					}
					m_VecDecoder[i].m_stPush[j][k].m_lPushID = iPushID;
					m_VecDecoder[i].m_stPush[j][k].m_pFile = pFile;
					m_VecDecoder[i].m_stPush[j][k].m_bStart = 1;
				}

				pthread_t tdSend = 0;
				//ط
				int iRet = pthread_create(&tdSend, NULL, threadPushStreamToDecoder, &m_VecDecoder[i].m_stPush[j][k]);
				if(iRet != 0)
					cout<<"Create sendstream thread failed!"<<endl;
			}
		}
	}

	return 0;
}

int AddNVS_Ex()
{
	//structֵ
	TNVSITEMEX nvsItemEx;
	memset(&nvsItemEx, 0, sizeof(TNVSITEMEX));
	nvsItemEx.m_iStructLen = sizeof(TNVSITEMEX);
	char RTSPAddr[79] = {0};
	cout<<"RTSP Address:"<<endl;
	//cin>>RTSPAddr;
	gets_s(RTSPAddr, 79);
	strcpy(nvsItemEx.m_stOldItem.m_cRTSPUrl,RTSPAddr);
	nvsItemEx.m_stOldItem.m_bUseddns = 0;


	nvsItemEx.m_stOldItem.m_serChan = 0;
	nvsItemEx.m_stOldItem.m_serStream = 0;
	nvsItemEx.m_stOldItem.m_serNetmode = 1;

	nvsItemEx.m_stOldItem.m_holdtime = 10;
	nvsItemEx.m_stOldItem.m_serPort = 3000;
	strcpy(nvsItemEx.m_stOldItem.m_username, "Admin");
	strcpy(nvsItemEx.m_stOldItem.m_password, "1111");
	strcpy(nvsItemEx.m_stOldItem.m_deviceType, "PelcoD");
	nvsItemEx.m_stOldItem.m_iAddress = 0;
	
	strcpy(nvsItemEx.m_cEncyptPWD, "null");
	nvsItemEx.m_iDevPlatType = 3;	//0-nomarl, 1-onvif, 2-PushStream, 3-RTSP

	for (int i=0; i<MAX_NVSNUM; i++)
	{
		if (!g_pNvsArr[i])
		{
			g_pNvsArr[i] = new NVSINFO();
			g_pNvsArr[i]->m_iDecID = 0;
			g_pNvsArr[i]->m_iChan = 0;
			g_pNvsArr[i]->m_iPic = 0;
			memcpy(&(g_pNvsArr[i]->m_viewItemEx), &nvsItemEx, sizeof(TNVSITEMEX));
		}
	}

	int iRet = -1;
	int iIndex = -1;
	iIndex = pClsNVD->DEC_ClientGetLoopItemCount(0, 0, 0);
	if (iIndex >= 0)
	{
		iRet = pClsNVD->DEC_ClientSetLoopItemEx(0, iIndex, &nvsItemEx, 0, 0);
		if (iRet < 0)
		{
			cout<<"Add failed, ret = "<<iRet<<endl;
			return iRet;
		}
	}

	return 1;
}

//ƵܺͷǱ׼H264ݲ
/*static int FindStartFrame(char *Buf)
{
	if(Buf[0]!=28 || Buf[1]!=0 || Buf[2] != 0 || Buf[3] != 0 
	   || Buf[4] != 80 || Buf[5] != 0 || Buf[6] != 0 || Buf[7] != 0) 
		return -1; //жǷΪ28 00 00 00 80 00 00 00,Ƿ0
	else
		 return 0;
}*/
//ĳݴ
char *chp_SearchNum(char *chp_Src, unsigned int liv_SrcSize,const char *chp_Num, unsigned int liv_NumSize)
{
	unsigned int iM;
	unsigned int iN;
	if (liv_SrcSize < liv_NumSize)
	{
		return NULL;
	}
	for (iM = 0; iM < liv_SrcSize - liv_NumSize; iM++)
	{
		for(iN = 0; iN < liv_NumSize; iN++)
		{
			if (*(chp_Src + iM + iN) == *(chp_Num + iN))
			{
				if (iN == (liv_NumSize - 1))
				{
					return (char *)(chp_Src + iM);
				}
			} 
			else
			{
				break;
			}
		}
	}
	return NULL;
}

typedef struct
{
    unsigned int	u32FrameID1;    	//32
	unsigned int	u32FrameID2;		//32
    unsigned int	u32FrameSize;	//֡С32λ֡Сֽ
    unsigned char	reserved[20];		//16λ
}_FrameHeader;

void* threadPushStreamToDecoderEx(void* _pvPara)
{
	st_PushStream* pstPush = (st_PushStream*)_pvPara;

	//char cFrameStart[32*1024] = {0};
	char cFlag[8] = {(char)0x28, (char)0x00, (char)0x00, (char)0x00, (char)0x80, (char)0x00, (char)0x00, (char)0x00};
	char cDataBuf[MAX_PUSH_STREAM_LEN];
	char* pFirst = NULL;
	//char* pSecond = NULL;
	//int iFrameLen = 0;
	//int ss = -1;
	//_FrameHeader header = {0};
	int iLeftLen = 0;
	int iAll = 0; 
	while(!g_bStopSendThread)
	{
		if(pstPush->m_bStart == 1)
		{
			while(pstPush->m_pReadFile && !feof(pstPush->m_pReadFile))
			{
				int iPos1 = 0; 
				int iPos2 = 0;
				while(true) 
				{
					int iCurPos = ftell(pstPush->m_pFile);
					int iReadLen = fread(cDataBuf + iLeftLen, sizeof(char), 
										 MAX_PUSH_STREAM_LEN - iLeftLen, pstPush->m_pFile);
					iAll = iAll + iReadLen;
					pFirst = chp_SearchNum(cDataBuf, MAX_PUSH_STREAM_LEN, cFlag, 8);
					
					if( pFirst != NULL )
					{
						iPos1 = (pFirst - cDataBuf - iLeftLen) + iCurPos;
						iLeftLen = MAX_PUSH_STREAM_LEN - (pFirst - cDataBuf + 8);
						memmove(cDataBuf, pFirst + 8, iLeftLen);
						break;
					}
				}

				while(true) 
				{
					int iCurPos = ftell(pstPush->m_pFile);
					fread(cDataBuf + iLeftLen, sizeof(char), 
										 MAX_PUSH_STREAM_LEN - iLeftLen, pstPush->m_pFile);
					pFirst = chp_SearchNum(cDataBuf, MAX_PUSH_STREAM_LEN, cFlag, 8);
					
					if( pFirst != NULL )
					{
						iPos2 = (pFirst - cDataBuf - iLeftLen) + iCurPos;
						iLeftLen = MAX_PUSH_STREAM_LEN - (pFirst - cDataBuf);
						memmove(cDataBuf, pFirst, iLeftLen);
						break;
					}
				}

				int iFrameLen = iPos2 - iPos1;
				printf("=========Pos1(%x),iPos2(%x),framelen(%d)", iPos1,iPos2, iFrameLen);
				//unsigned char* pucSendBuf = new unsigned char[iFrameLen];
				char cSendBuf[1024*16] = {0};
				fread(cSendBuf, iFrameLen, 1, pstPush->m_pReadFile);
				pClsNVD->procDEC_ClientSendNonstandardRawFrame(pstPush->m_lPushID, iFrameLen, cSendBuf);
				//delete[] pucSendBuf;
			}
		}
		else
		{
			fprintf(stderr, "=================Thread quit here...\n");
			return NULL;
			//usleep(100);
		}	
	}

	return NULL;
}

int SetVolume()
{
	SafeGetInt();

	int iID = -1;
	int iVolume = -1;
	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();
	int iRet = pClsNVD->procDEC_GetVolume(iID, &iVolume);
	if(iRet < 0)
	{
		cout<<"Get system volume is fail!"<<endl;
	}
	else
	{
		cout<<"System current volume is "<<iVolume<<endl;
	}
	cout<<"Please input new volume:"<<endl;
	cout<<"Volume:"<<endl;
	//cin>>iVolume;
	iVolume = SafeGetInt();
	iRet = pClsNVD->procDEC_SetVolume(iID, iVolume);
	if(iRet < 0)
	{
		cout<<"Set volume fail!Return value is"<<iRet<<endl;
	}
	else
	{
		cout<<"Set volume success!"<<endl;
	}

	return 1;
}

int SetPreviewPreference()
{
	SafeGetInt();

	int iID = -1;
	int iEnableValue = -1;

	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();
	cout<<"Preference:0-->LOWDELAY,1-->SMOOTH"<<endl;
	//cin>>iEnableValue;
	iEnableValue = SafeGetInt();

	int iRet = -1;
	iRet = pClsNVD->procDEC_ClientSetCommonEnable(iID, COMMONID_PREVIEW_PREFERENCE, 0x7fffffff, iEnableValue);
	if (iRet < 0)
	{
		cout<<"Set[COMMONID_PREVIEW_PREFERENCE] fail!Return value"<<iRet<<endl;
	}

	return 1;
}

int SetNetCutHoldLastFrame()
{
	SafeGetInt();

	int iID = -1;
	int iEnableValue = -1;

	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();
	cout<<"If hold last frame:0-->disable,1-->enable"<<endl;
	//cin>>iEnableValue;
	iEnableValue = SafeGetInt();

	int iRet = -1;
	iRet = pClsNVD->procDEC_ClientSetCommonEnable(iID, COMMONID_NETCUT_HOLD_LASTFRAME, 0x7fffffff, iEnableValue);
	if (iRet < 0)
	{
		cout<<"Set[COMMONID_NETCUT_HOLD_LASTFRAME] fail!Return value"<<iRet<<endl;
	}

	return 1;
}

int StartPushStream_V1()
{
	SafeGetInt();

	int iID = -1;
	int iChannel = -1;
	int iPushID = -1;
	int iPos = -1;
	char cEncryptKey[17] = {0};
	int iCmdValue = PUSH_PLAYBACK_STREAM_PLAY;

	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();
	cout<<"Channel:"<<endl;
	//cin>>iChannel;
	iChannel = SafeGetInt();
	cout<<"Picture no."<<endl;
	//cin>>iPos;
	iPos = SafeGetInt();
	cout<<"EncryptKey:(Input \"NULL\" to set pwd NULL.)"<<endl;
	//cin>>cEncryptKey;
	gets_s(cEncryptKey, 17);

	if(!strcmp(cEncryptKey, ""))
	{
		if(!strcmp(cEncryptKey, "NULL"))
		{
			strcpy(cEncryptKey,"NULL");
		}
	}
	
	if (m_VecDecoder[iID].m_stPush[iChannel][iPos].m_bStart == 1)
	{
		cout<<"Already pushing ........."<<endl;
	}
	else
	{
		string FileName;
		cout<<"Please specify SDV file(*.sdv):"<<endl;

		cin>>FileName;

		pFile = fopen(FileName.c_str(),"rb");
		if(NULL == pFile)
		{
			cout<<"Open file failed!!!"<<endl;
			return 1;
		}

		S_header fileHeader = {0};
		fread(&fileHeader,sizeof(char),sizeof(S_header),pFile);
		//ļݿ͸߻ƵСʵʹǲ
		//int iVideoSize = VIDEO_FD1;
		//iVideoSize = CalculateVideoSize(&fileHeader);

		START_PUSH_PARAM strStartPushParam = {0};
		strStartPushParam.m_iSize = sizeof(START_PUSH_PARAM);
		memcpy(strStartPushParam.m_cFileHeader,&fileHeader,VIDEO_HEADER_SIZE);
		strncpy(strStartPushParam.m_cEncryptKey,cEncryptKey,MAX_ENCRYPT_KEY);
		iPushID = pClsNVD->procDEC_ClientStartPushStream_V1(iID, iChannel, iPos, &strStartPushParam);
		if(iPushID >= 0)
		{
			pClsNVD->procDEC_ClientStreamControl(iPushID, PUSH_STREAM_CMD_PAUSE, &iCmdValue, sizeof(int));//ע˴Ҫ
			if(m_VecDecoder[iID].m_stPush[iChannel][iPos].m_pFile)
			{
				cout<<"File is opened!!!"<<endl;
			}
			m_VecDecoder[iID].m_stPush[iChannel][iPos].m_lPushID = iPushID;
			m_VecDecoder[iID].m_stPush[iChannel][iPos].m_pFile = pFile;
			m_VecDecoder[iID].m_stPush[iChannel][iPos].m_bStart = 1;
		}

		//pthread_t tdSend = 0;
		//ط
		int iRet = pthread_create(&m_VecDecoder[iID].m_stPush[iChannel][iPos].m_tdSend, NULL, threadPushStreamToDecoder, &m_VecDecoder[iID].m_stPush[iChannel][iPos]);
		//pthread_detach(m_VecDecoder[iID].m_stPush[iChannel][iPos].m_tdSend);
		//ʵʱ
		//int iRet = pthread_create(&tdSend, NULL, threadPushStream, NULL);
		if(iRet != 0)
			cout<<"Create sendstream thread failed!"<<endl;
	}

	return 1;
}

int CalculateVideoSize(S_header* _pfileHeader)
{
	if (NULL == _pfileHeader)
	{
		return -1;
	}

	int iVideoSize = VIDEO_FD1;
	if(_pfileHeader->Width == 1920)
	{
		//1080p
		iVideoSize = VIDEO_HD_1080P;
	}
	else if (_pfileHeader->Width == 1600)
	{
		//QXVGA
		iVideoSize = VIDEO_HD_QXVGA;
	}
	else if(_pfileHeader->Width == 1280)
	{  
		if (_pfileHeader->Height == 720)
		{
			//720P
			iVideoSize = VIDEO_HD_720P;
		}
		else if (_pfileHeader->Height == 960)
		{
			//960P
			iVideoSize = VIDEO_HD_960P;
		}	
	}
	else if((_pfileHeader->Width == 704) || (_pfileHeader->Width == 720))
	{
		if(_pfileHeader->Height > 288)
		{   //D1
			iVideoSize =VIDEO_FD1;
		}
		else
		{   //HD1
			iVideoSize =VIDEO_HD1;
		}
	}
	else if(_pfileHeader->Width == 352)
	{   //CIF/HCIF
		if(_pfileHeader->Height > 144)
		{
			iVideoSize =VIDEO_FCIF;
		}
		else
		{
			iVideoSize =VIDEO_HCIF;
		}
	}
	else if(_pfileHeader->Width == 640)
	{   //VGA
		if(_pfileHeader->Height > 240)
		{
			iVideoSize =VIDEO_VGA;
		}
		else
		{
			iVideoSize =VIDEO_HVGA;
		}
	}
	else if(_pfileHeader->Width == 320)
	{   //QVGA
		iVideoSize =VIDEO_QVGA;
	}
	else if(_pfileHeader->Width < 352)
	{   //QCIF
		iVideoSize =VIDEO_QCIF;
	}
	else if(_pfileHeader->Width == 2048)
	{   //300W
		iVideoSize = VIDEO_HD_QXGA;
	}
	else if(_pfileHeader->Width == 960)
	{   
		if (_pfileHeader->Height == 540)
		{
			//QHD
			iVideoSize = QHD;
		}
		else if (_pfileHeader->Height == 576)
		{
			//960H
			iVideoSize = VZ_960H;
		}
	}
	else if(_pfileHeader->Width == 2448)
	{   //500W(1)
		iVideoSize = VZ_5MA;
	}
	else if(_pfileHeader->Width == 2560)
	{   
		if (_pfileHeader->Height == 1920)
		{
			//500W(2)
			iVideoSize = VZ_5M;
		}
		else if (_pfileHeader->Height == 2048)
		{
			//500W(3)
			iVideoSize = VZ_QSXGA;
		}
	}
	else if (_pfileHeader->Width == 720 && _pfileHeader->Height == 1280)
	{
		iVideoSize = F720P_9_16;
	}
	else if (_pfileHeader->Width == 1080 && _pfileHeader->Height == 1920)
	{
		iVideoSize = F1080P_9_16;
	}
	else
	{
		iVideoSize = VIDEO_FD1;
	}

	return iVideoSize;
}

int CutAllPushVideo()
{
	for(unsigned int i=0;i<m_VecDecoder.size();++i)
	{
		for(int j=0; j<DEC_MAX_CHANNEL_NUM_NEW+DEC_MAX_VIRTUAL_CHANNEL_NUM; ++j)
		{
			for(int k=0; k<DEC_MAX_PICTURE_NUM; ++k)
			{
				if(m_VecDecoder[i].m_stPush[j][k].m_bStart == 1)
				{
					pClsNVD->DEC_ClientStopPushStream(m_VecDecoder[i].m_stPush[j][k].m_lPushID);
				}
			}
		}
	}

	return 0;
}

int GetChannelState()
{
	SafeGetInt();

	int iID = -1;
	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();

	LocalChannelState tLocalChannelState = {0};
	tLocalChannelState.iBufSize = sizeof(LocalChannelState);
	for(int i=0; i<DEC_MAX_CHANNEL_NUM_NEW; ++i)
	{
		tLocalChannelState.iChannelNo = i;
		int iRet = pClsNVD->procDEC_ClientGetDevConfig(iID, 0, 0, CMD_DEC_CFG_CHANN_STATE, &tLocalChannelState, sizeof(LocalChannelState));
		if(iRet == 0)
		{	
			cout<<"Channel "<<i<<"state(0-  1-):"<<tLocalChannelState.iState<<endl;
		}
		else
			cout<<"[DEC_ClientGetDevConfig][CMD_DEC_CFG_CHANN_STATE] fail"<<iRet<<endl;
	}

	return 0;
}

int SetAlarmLinkSwitch()
{
	SafeGetInt();

	int iID = -1;
	cout<<"Please specify decorder id:"<<endl;
    iID = SafeGetInt();

	int iAlarmType = 0;
	cout<<"AlarmType(128:Ƶʧ;129:˿ڱ;130:ƶ;135:ض˿ڱ)"<<endl;
	//cin>>iAlarmType;
	iAlarmType = SafeGetInt();

	int iPortNo = 0;
	cout<<"iPortNo(ض˿ڱ,˿ڷΧ0-15):";
	//cin>>iPortNo;
	iPortNo = SafeGetInt();

	int iChan = 0;
	cout<<"Channel:"<<endl;
	//cin>>iChan;
	iChan = SafeGetInt();

	int iPos = 0;
	cout<<"iPos:"<<endl;
	//cin>>iPos;
	iPos = SafeGetInt();

	char cSerName[DEC_LEN_32] = {0};		//ǰ豸
	cout<<"Server name:"<<endl;
	//cin>>cSerName;
	gets_s(cSerName, DEC_LEN_32);

	char cSerIP[DEC_LEN_16] = {0};		//ǰ豸IPַ
	cout<<"Server IP:"<<endl;
	//cin>>cSerIP;
	gets_s(cSerIP, DEC_LEN_16);

	char cSerProxy[DEC_LEN_16];		//ǰ豸IP
	cout<<"Server Proxy IP:(Input \"NULL\" to set proxyip NULL.)"<<endl;
	//cin>>cSerProxy;
	gets_s(cSerProxy, DEC_LEN_16);

	int  iSerChan;					//ǰ豸ͨ
	cout<<"Server Channel:"<<endl;
	//cin>>iSerChan;
	iSerChan = SafeGetInt();

	int iStream = -1;
	cout<<"Stream:(main:0,sub:1)"<<endl;
	//cin>>iStream;
	iStream = SafeGetInt();

	int iNetMode = -1;
	cout<<"Net Mode:(TCP:1,UDP:2,MU:3)"<<endl;
	//cin>>iNetMode;
	iNetMode = SafeGetInt();

	int	 iUseddns;					//Ƿʹddns	0IP13ģʽ	
	cout<<"Use DDNS:(IP:0, :2, ģʽ:3)"<<endl;
	//cin>>iUseddns;
	iUseddns = SafeGetInt();

	int  iSerPort;					//˿ں
	cout<<"Server Port:"<<endl;
	//cin>>iSerPort;
	iSerPort = SafeGetInt();

	char cUserName[DEC_LEN_32];		//ǰ豸¼û
	cout<<"Server user name:"<<endl;
	//cin>>cUserName;
	gets_s(cUserName, DEC_LEN_32);

	char cPassword[DEC_LEN_32];		//ǰ豸¼
	cout<<"Server User Password:"<<endl;
	//cin>>cPassword;
	gets_s(cPassword, DEC_LEN_32);

	char cEncrypt[DEC_LEN_32];		//ǰ豸Ƶ
	cout<<"Server Encrypt(Input \"NULL\" to set Encrypt NULL.):"<<endl;
	//cin>>cEncrypt;
	gets_s(cEncrypt, DEC_LEN_32);

	int iHoldTime = -1;
	cout<<"Hold Time:(10~1000)"<<endl;
	//cin>>iHoldTime;
	iHoldTime = SafeGetInt();

	int  iSerType;					//ǰ豸	0Tiandy1Onvif2push
	cout<<"Server Type:(0Tiandy1Onvif2push)"<<endl;
	//cin>>iSerType;
	iSerType = SafeGetInt();

	AlarmLinkSwitch tAlarmLinkSwitch = {0};
	tAlarmLinkSwitch.iAlarmType = iAlarmType;					
	tAlarmLinkSwitch.iPortNo = iPortNo;						
	tAlarmLinkSwitch.iChannelNo = iChan;					
	tAlarmLinkSwitch.iPos = iPos;						//						
	strcpy(tAlarmLinkSwitch.cSerName, cSerName);						
	strcpy(tAlarmLinkSwitch.cSerIP, cSerIP);
	strcpy(tAlarmLinkSwitch.cSerProxy, cSerProxy);						
	if(0 != strcmp(cSerProxy, ""))
	{
		strcpy(tAlarmLinkSwitch.cSerProxy, cSerProxy);	
	}						
	tAlarmLinkSwitch.iSerChan = iSerChan;					//ǰ豸ͨ						
	tAlarmLinkSwitch.iSerStreamNo = iStream;				//	0,1					
	tAlarmLinkSwitch.iSerNetmode = iNetMode;				//ģʽ	1TCP2UDP3ಥ					
	tAlarmLinkSwitch.iUseddns = iUseddns;					//Ƿʹddns	0IP13ģʽ					
	tAlarmLinkSwitch.iSerPort = iSerPort;					//˿ں						
	strcpy(tAlarmLinkSwitch.cUserName, cUserName);
	strcpy(tAlarmLinkSwitch.cPassword, cPassword);
	tAlarmLinkSwitch.iHoldTime = iHoldTime;
	strcpy(tAlarmLinkSwitch.cEncrypt, cEncrypt);
	tAlarmLinkSwitch.iSerType = iSerType;	

	tAlarmLinkSwitch.iBufSize = sizeof(AlarmLinkSwitch);
	int iRet = pClsNVD->procDEC_ClientSetDevConfig(iID, 0, 0, CMD_DEC_CFG_ALARM_LINK_SWITCH, &tAlarmLinkSwitch, sizeof(AlarmLinkSwitch));
	if(iRet == 0)
		cout<<"[DEC_ClientSetDevConfig][CMD_DEC_CFG_ALARM_LINK_SWITCH] ok"<<endl;
	else
		cout<<"[DEC_ClientSetDevConfig][CMD_DEC_CFG_ALARM_LINK_SWITCH] fail"<<iRet<<endl;

	return 0;
}

int GetAlarmLinkSwitch()
{
	SafeGetInt();

	int iID = -1;
	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();

	int iAlarmType = 0;
	cout<<"AlarmType(128:Ƶʧ;129:˿ڱ;130:ƶ;135:ض˿ڱ)"<<endl;
	//cin>>iAlarmType;
	iAlarmType = SafeGetInt();

	int iPortNo = 0;
	cout<<"iPortNo(˿ڷΧ0-15)"<<endl;
	//cin>>iPortNo;
	iPortNo = SafeGetInt();

	AlarmLinkSwitch tAlarmLinkSwitch = {0};
	tAlarmLinkSwitch.iBufSize = sizeof(AlarmLinkSwitch);
	tAlarmLinkSwitch.iAlarmType = iAlarmType;
	tAlarmLinkSwitch.iPortNo = iPortNo;
	int iRet = pClsNVD->procDEC_ClientGetDevConfig(iID, 0, 0, CMD_DEC_CFG_ALARM_LINK_SWITCH, &tAlarmLinkSwitch, sizeof(AlarmLinkSwitch));
	if(iRet == 0)
	{
		cout<<"AlarmType:"<<tAlarmLinkSwitch.iAlarmType<<endl;
		cout<<"iPortNo(ض˿ڱ):"<<tAlarmLinkSwitch.iPortNo<<endl;
		cout<<"Channel:"<<tAlarmLinkSwitch.iChannelNo<<endl;
		cout<<"iPos:"<<tAlarmLinkSwitch.iPos<<endl;
		cout<<"Server name:"<<tAlarmLinkSwitch.cSerName<<endl;
		cout<<"Server IP:"<<tAlarmLinkSwitch.cSerIP<<endl;
		cout<<"Server Proxy IP:"<<tAlarmLinkSwitch.cSerProxy<<endl;
		cout<<"Server Channel:"<<tAlarmLinkSwitch.iSerChan<<endl;
		cout<<"StreamNo(main:0,sub:1):"<<tAlarmLinkSwitch.iSerStreamNo<<endl;
		cout<<"Net Mode(TCP:1,UDP:2,MU:3):"<<tAlarmLinkSwitch.iSerNetmode<<endl;
		cout<<"Use DDNS(IP:0, :1, ģʽ:3):"<<tAlarmLinkSwitch.iUseddns<<endl;
		cout<<"Server Port:"<<tAlarmLinkSwitch.iSerPort<<endl;
		cout<<"Server user name:"<<tAlarmLinkSwitch.cUserName<<endl;
		cout<<"Server User Password:"<<tAlarmLinkSwitch.cPassword<<endl;
		cout<<"Server Encrypt:"<<tAlarmLinkSwitch.cEncrypt<<endl;
		cout<<"Hold Time(10~1000):"<<tAlarmLinkSwitch.iHoldTime<<endl;
		cout<<"Server Type(0Tiandy1Onvif2push):"<<tAlarmLinkSwitch.iSerType<<endl;
	}
	else
		cout<<"[DEC_ClientGetDevConfig][CMD_DEC_CFG_ALARM_LINK_SWITCH] fail"<<iRet<<endl;

	return 0;
}

int CreateVVO()
{
	SafeGetInt();

	int iID = -1;
	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();

	int iVVOChannelNo = -1;
	cout<<"ƴͨiVVOChannelNo(Χ16-23):"<<endl;
	//cin>>iVVOChannelNo;
	iVVOChannelNo = SafeGetInt();

	int iRows = 0;
	cout<<"ƴiRaws:"<<endl;
	//cin>>iRows;
	iRows = SafeGetInt();

	int iCols = 0;
	cout<<"ƴiCols:"<<endl;
	//cin>>iCols;
	iCols = SafeGetInt();

	CreateVVOInfo tCreateVVOInfo = {0};
	tCreateVVOInfo.iBufSize = sizeof(CreateVVOInfo);
	tCreateVVOInfo.iVVOChannelNo = iVVOChannelNo;
	tCreateVVOInfo.iRows = iRows;
	tCreateVVOInfo.iCols = iCols;
	cout<<iRows*iCols<<"󶨵ͨţû0x7fffffffʾ"<<endl;
	for (int i = 0; i < iRows*iCols; i++)
	{
		cout<<"Screen"<<i<<":"<<endl;
		//cin>>tCreateVVOInfo.iInputChannel[i];
		tCreateVVOInfo.iInputChannel[i] = SafeGetInt();
		for (int j=0; j < i; j++)
		{
			if(tCreateVVOInfo.iInputChannel[i] == tCreateVVOInfo.iInputChannel[j])
			{
				cout<<"ͨѱ󶨣°󶨣"<<endl;
				i--;
				break;
			}
		}
	}

	int iRet = pClsNVD->procDEC_ClientSetDevConfig(iID, 0, 0, CMD_DEC_CFG_CREATE_VVO, &tCreateVVOInfo, sizeof(CreateVVOInfo));
	if(iRet == 0)
		cout<<"[DEC_ClientSetDevConfig][CMD_DEC_CFG_CREATE_VVO] ok"<<endl;
	else
		cout<<"[DEC_ClientSetDevConfig][CMD_DEC_CFG_CREATE_VVO] fail"<<iRet<<endl;

	return 0;
}

int ShowVVOInfo()
{
	SafeGetInt();

	int iID = -1;
	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();

	int iVVOChannelNo = -1;
	cout<<"ƴͨiVVOChannelNo(Χ16-23):"<<endl;
	//cin>>iVVOChannelNo;
	iVVOChannelNo = SafeGetInt();

	CreateVVOInfo tCreateVVOInfo = {0};
	tCreateVVOInfo.iBufSize = sizeof(CreateVVOInfo);
	tCreateVVOInfo.iVVOChannelNo = iVVOChannelNo;
	int iRet = pClsNVD->procDEC_ClientGetDevConfig(iID, 0, 0, CMD_DEC_CFG_CREATE_VVO, &tCreateVVOInfo, sizeof(CreateVVOInfo));
	if(iRet == 0)
	{
		cout<<"ƴͨiVVOChannelNo:"<<tCreateVVOInfo.iVVOChannelNo<<endl;
		cout<<"ƴiRows:"<<tCreateVVOInfo.iRows<<endl;
		cout<<"ƴiCols:"<<tCreateVVOInfo.iCols<<endl;
		cout<<tCreateVVOInfo.iRows*tCreateVVOInfo.iCols<<"󶨵ͨţû0x7fffffffʾ"<<endl;
		for (int i=0; i<tCreateVVOInfo.iRows*tCreateVVOInfo.iCols; i++)
		{
			cout<<"Screen"<<i<<":"<<tCreateVVOInfo.iInputChannel[i]<<endl;
		}
	}
	else
		cout<<"[DEC_ClientGetDevConfig][CMD_DEC_CFG_CREATE_VVO] fail!"<<iRet<<endl;

	return 0;
}

int SetSplitScreen()
{
	SafeGetInt();

	int iID = -1;
	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();

	int iVVOChannelNo = -1;
	cout<<"ƴͨiVVOChannelNo(Χ16-23):"<<endl;
	//cin>>iVVOChannelNo;
	iVVOChannelNo = SafeGetInt();

	int iPicNum = 0;
	cout<<"ָiPicNum:"<<endl;
	//cin>>iPicNum;
	iPicNum = SafeGetInt();

	SplitScreen tSplitScreen = {0};
	tSplitScreen.iBufSize = sizeof(SplitScreen);
	tSplitScreen.iVVOChannelNo = iVVOChannelNo;
	tSplitScreen.iPicNum = iPicNum;
	cout<<""<<iPicNum<<"ָ:"<<endl;
	for (int i=0; i<iPicNum; i++)
	{
		tSplitScreen.tSplitScreenPara[i].iBufSize = sizeof(ScreenPara);
		cout<<"Picture"<<i<<":"<<endl;
		cout<<"ʼiX:"<<endl;
		//cin>>tSplitScreen.tSplitScreenPara[i].iX;
		tSplitScreen.tSplitScreenPara[i].iX = SafeGetInt();
		cout<<"ʼiY:"<<endl;
		//cin>>tSplitScreen.tSplitScreenPara[i].iY;
		tSplitScreen.tSplitScreenPara[i].iY = SafeGetInt();
		cout<<"iWidth:"<<endl;
		//cin>>tSplitScreen.tSplitScreenPara[i].iWidth;
		tSplitScreen.tSplitScreenPara[i].iWidth = SafeGetInt();
		cout<<"iHeight:"<<endl;
		//cin>>tSplitScreen.tSplitScreenPara[i].iHeight;
		tSplitScreen.tSplitScreenPara[i].iHeight = SafeGetInt();
	}

	int iRet = pClsNVD->procDEC_ClientSetDevConfig(iID, 0, 0, CMD_DEC_CFG_SPLIT_SCREEN, &tSplitScreen, sizeof(SplitScreen));
	if(iRet == 0)
		cout<<"[DEC_ClientSetDevConfig][CMD_DEC_CFG_SPLIT_SCREEN] ok"<<endl;
	else
		cout<<"[DEC_ClientSetDevConfig][CMD_DEC_CFG_SPLIT_SCREEN] fail"<<iRet<<endl;

	return 0;
}

int ShowSplitScreenInfo()
{
	SafeGetInt();

	int iID = -1;
	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();

	int iVVOChannelNo = -1;
	cout<<"ƴͨiVVOChannelNo(Χ16-23):"<<endl;
	//cin>>iVVOChannelNo;
	iVVOChannelNo = SafeGetInt();

	SplitScreen tSplitScreen = {0};
	tSplitScreen.iBufSize = sizeof(SplitScreen);
	tSplitScreen.iVVOChannelNo = iVVOChannelNo;
	int iRet = pClsNVD->procDEC_ClientGetDevConfig(iID, 0, 0, CMD_DEC_CFG_SPLIT_SCREEN, &tSplitScreen, sizeof(SplitScreen));
	if(iRet == 0)
	{
		cout<<"ƴͨiVVOChannelNo:"<<tSplitScreen.iVVOChannelNo<<endl;
		cout<<"ָiPicNum:"<<tSplitScreen.iPicNum<<endl;
		cout<<"ָ:"<<endl;
		for (int i=0; i<tSplitScreen.iPicNum; i++)
		{
			cout<<"ʼiX:"<<tSplitScreen.tSplitScreenPara[i].iX<<endl;
			cout<<"ʼiY:"<<tSplitScreen.tSplitScreenPara[i].iY<<endl;
			cout<<"iWidth:"<<tSplitScreen.tSplitScreenPara[i].iWidth<<endl;
			cout<<"iHeight:"<<tSplitScreen.tSplitScreenPara[i].iHeight<<endl;
		}
	}
	else
		cout<<"[DEC_ClientGetDevConfig][CMD_DEC_CFG_SPLIT_SCREEN] fail"<<iRet<<endl;

	return 0;
}

int SetAlarmSchedule()
{
	SafeGetInt();

	int iID = -1;
	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();

	int iChannelNo = 0;
	cout<<"iChannelNo(Χ0-15:"<<endl;
	//cin>>iChannelNo;
	iChannelNo = SafeGetInt();

	int iAlarmType = 0;
	cout<<"iAlarmType(128Ƶʧ129˿ڱ130ƶ⣻135ض˿ڱ):"<<endl;
	//cin>>iAlarmType;
	iAlarmType = SafeGetInt();

	int iWeekday = 0;
	cout<<"iWeekday(յ0-6):"<<endl;
	//cin>>iWeekday;
	iWeekday = SafeGetInt();

	int iParam1 = 0;
	cout<<"iParam1:"<<endl;
	//cin>>iParam1;
	iParam1 = SafeGetInt();

	int iParam2 = 0;
	cout<<"iParam2:"<<endl;
	//cin>>iParam2;
	iParam2 = SafeGetInt();

	cout<<"ʱ"<<endl;
	int iStartHour = 0;
	cout<<"iStartHour:"<<endl;
	//cin>>iStartHour;
	iStartHour = SafeGetInt();

	int iStartMin = 0;
	cout<<"iStartMin:"<<endl;
	//cin>>iStartMin;
	iStartMin = SafeGetInt();

	int iStopHour = 0;
	cout<<"iStopHour:"<<endl;
	//cin>>iStopHour;
	iStopHour = SafeGetInt();

	int iStopMin = 0;
	cout<<"iStopMin:"<<endl;
	//cin>>iStopMin;
	iStopMin = SafeGetInt();

	int iEnable = 0;
	cout<<"iEnable:"<<endl;
	//cin>>iEnable;
	iEnable = SafeGetInt();

	AlarmScheduleParam tAlarmScheduleParam = {0};
	tAlarmScheduleParam.iBuffSize = sizeof(AlarmScheduleParam);
	tAlarmScheduleParam.iChannelNo = iChannelNo;
	tAlarmScheduleParam.iAlarmType = iAlarmType;
	tAlarmScheduleParam.iWeekday = iWeekday;
	tAlarmScheduleParam.iParam1 = iParam1;
	tAlarmScheduleParam.iParam1 = iParam2;
	if (iWeekday < 0 || iWeekday >= DEC_MAX_DAYS)
		return -1;
	tAlarmScheduleParam.timeSeg[iWeekday][0].iStartHour = iStartHour;
	tAlarmScheduleParam.timeSeg[iWeekday][0].iStartMin = iStartMin;
	tAlarmScheduleParam.timeSeg[iWeekday][0].iStopHour = iStopHour;
	tAlarmScheduleParam.timeSeg[iWeekday][0].iStopMin = iStopMin;
	tAlarmScheduleParam.timeSeg[iWeekday][0].iEnable = iEnable;

	int iRet = pClsNVD->procDEC_ClientSetDevConfig(iID, 0, 0, CMD_DEC_CFG_ALARM_SCHEDULE, &tAlarmScheduleParam, sizeof(AlarmScheduleParam));
	if(iRet == 0)
		cout<<"[DEC_ClientSetDevConfig][CMD_DEC_CFG_ALARM_SCHEDULE] ok"<<endl;
	else
		cout<<"[DEC_ClientSetDevConfig][CMD_DEC_CFG_ALARM_SCHEDULE] fail"<<iRet<<endl;

	return 0;
}

int GetAlarmSchedule()
{
	SafeGetInt();

	int iID = -1;
	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();

	int iChannelNo = 0;
	cout<<"iChannelNo(Χ0-15:"<<endl;
	//cin>>iChannelNo;
	iChannelNo = SafeGetInt();

	int iAlarmType = 0;
	cout<<"iAlarmType(128Ƶʧ129˿ڱ130ƶ⣻135ض˿ڱ):"<<endl;
	//cin>>iAlarmType;
	iAlarmType = SafeGetInt();

	AlarmScheduleParam tAlarmScheduleParam = {0};
	tAlarmScheduleParam.iBuffSize = sizeof(AlarmScheduleParam);
	tAlarmScheduleParam.iChannelNo = iChannelNo;
	tAlarmScheduleParam.iAlarmType = iAlarmType;
	int iRet = pClsNVD->procDEC_ClientGetDevConfig(iID, 0, 0, CMD_DEC_CFG_ALARM_SCHEDULE, &tAlarmScheduleParam, sizeof(AlarmScheduleParam));
	if(iRet == 0)
	{
		cout<<"ͨiChannelNo:"<<tAlarmScheduleParam.iChannelNo<<endl;
		cout<<"iAlarmType:"<<tAlarmScheduleParam.iAlarmType<<endl;
		cout<<"iParam1:"<<tAlarmScheduleParam.iParam1<<endl;
		cout<<"iParam2:"<<tAlarmScheduleParam.iParam2<<endl;
		for (int iWeekday=0; iWeekday<DEC_MAX_DAYS; ++iWeekday)
		{
			cout<<"Week"<<iWeekday<<":"<<endl;
			cout<<"iStartHour:"<<tAlarmScheduleParam.timeSeg[iWeekday][0].iStartHour<<endl;
			cout<<"iStartMin:"<<tAlarmScheduleParam.timeSeg[iWeekday][0].iStartMin<<endl;
			cout<<"iStopHour:"<<tAlarmScheduleParam.timeSeg[iWeekday][0].iStopHour<<endl;
			cout<<"iStopMin:"<<tAlarmScheduleParam.timeSeg[iWeekday][0].iStopMin<<endl;
			cout<<"iEnable:"<<tAlarmScheduleParam.timeSeg[iWeekday][0].iEnable<<endl;
		}
	}
	else
		cout<<"[DEC_ClientGetDevConfig][CMD_DEC_CFG_ALARM_SCHEDULE] fail!"<<iRet<<endl;

	return 0;
}

int SetAlarmLink()
{
	SafeGetInt();

	int iID = -1;
	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();

	int iChannelNo = 0;
	cout<<"iChannelNo(Χ0-15:"<<endl;
	//cin>>iChannelNo;
	iChannelNo = SafeGetInt();

	int iAlarmType = 0;
	cout<<"iAlarmType(128Ƶʧ129˿ڱ130ƶ⣻135ض˿ڱ):"<<endl;
	//cin>>iAlarmType;
	iAlarmType = SafeGetInt();

	int iAlarmTypeParam = 0;
	cout<<"iAlarmTypeParam(ȡֵiAlarmTypeiAlarmTypeΪܷiAlarmTypeParamʾiRuleID):"<<endl;
	//cin>>iAlarmTypeParam;
	iAlarmTypeParam = SafeGetInt();

	int iLinkType = 0;
	cout<<"iLinkType(,0ʾ1Ļʾ2˿ڣ3¼4PTZ5ץģ):"<<endl;
	//cin>>iLinkType;
	iLinkType = SafeGetInt();

	int iLinkParam1 = 0;
	cout<<"iLinkParam1:"<<endl;
	//cin>>iLinkParam1;
	iLinkParam1 = SafeGetInt();

	int iLinkParam2 = 0;
	cout<<"iLinkParam2:"<<endl;
	//cin>>iLinkParam2;
	iLinkParam2 = SafeGetInt();

	int iLinkParam3 = 0;
	cout<<"iLinkParam3:"<<endl;
	//cin>>iLinkParam3;
	iLinkParam3 = SafeGetInt();

	AlarmLink tAlarmLink = {0};
	tAlarmLink.iBuffSize = sizeof(AlarmLink);
	tAlarmLink.iChannelNo = iChannelNo;
	tAlarmLink.iAlarmType = iAlarmType;
	tAlarmLink.iAlarmTypeParam = iAlarmTypeParam;
	tAlarmLink.iLinkType = iLinkType;
	tAlarmLink.iLinkParam1 = iLinkParam1;
	tAlarmLink.iLinkParam2 = iLinkParam2;
	tAlarmLink.iLinkParam3 = iLinkParam3;

	int iRet = pClsNVD->procDEC_ClientSetDevConfig(iID, 0, 0, CMD_DEC_CFG_ALARM_LINK, &tAlarmLink, sizeof(AlarmLink));
	if(iRet == 0)
		cout<<"[DEC_ClientSetDevConfig][CMD_DEC_CFG_ALARM_LINK] ok"<<endl;
	else
		cout<<"[DEC_ClientSetDevConfig][CMD_DEC_CFG_ALARM_LINK] fail!"<<iRet<<endl;

	return 0;
}

int GetAlarmLink()
{
	SafeGetInt();

	int iID = -1;
	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();

	int iChannelNo = 0;
	cout<<"iChannelNo(Χ0-15:"<<endl;
	//cin>>iChannelNo;
	iChannelNo = SafeGetInt();

	int iAlarmType = 0;
	cout<<"iAlarmType(128Ƶʧ129˿ڱ130ƶ⣻135ض˿ڱ):"<<endl;
	//cin>>iAlarmType;
	iAlarmType = SafeGetInt();

	AlarmLink tAlarmLink = {0};
	tAlarmLink.iBuffSize = sizeof(AlarmLink);
	tAlarmLink.iChannelNo = iChannelNo;
	tAlarmLink.iAlarmType = iAlarmType;
	int iRet = pClsNVD->procDEC_ClientGetDevConfig(iID, 0, 0, CMD_DEC_CFG_ALARM_LINK, &tAlarmLink, sizeof(AlarmLink));
	if(iRet == 0)
	{
		cout<<"ͨiChannelNo:"<<tAlarmLink.iChannelNo<<endl;
		cout<<"iAlarmType:"<<tAlarmLink.iAlarmType<<endl;
		cout<<"ͲiAlarmTypeParam:"<<tAlarmLink.iAlarmTypeParam<<endl;
		cout<<"iLinkType:"<<tAlarmLink.iLinkType<<endl;
		cout<<"iLinkParam1:"<<tAlarmLink.iLinkParam1<<endl;
		cout<<"iLinkParam2:"<<tAlarmLink.iLinkParam2<<endl;
		cout<<"iLinkParam3:"<<tAlarmLink.iLinkParam3<<endl;
	}
	else
		cout<<"[DEC_ClientGetDevConfig][CMD_DEC_CFG_ALARM_LINK] fail!"<<iRet<<endl;

	return 0;
}

int SetAlarmInAndOut()
{
	SafeGetInt();

	int iID = -1;
	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();

	int iType = 0;
	cout<<"iType(0ߵ͵ƽã1ߵ͵ƽã2˿ʹܣ3˿ʹ):"<<endl;
	//cin>>iType;
	iType = SafeGetInt();

	int iPortNo = 0;
	cout<<"iPortNo(˿ں0-15):"<<endl;
	//cin>>iPortNo;
	iPortNo = SafeGetInt();

	int iPara1 = 0;
	cout<<"iPara1(iTypeȡֵй,0-·1-·)򱨾˿ʹ):"<<endl;
	//cin>>iPara1;
	iPara1 = SafeGetInt();

	int iPara2 = 0;
	cout<<"iPara2(iTypeȡֵй):"<<endl;
	//cin>>iPara2;
	iPara2 = SafeGetInt();

	AlarmInAndOut tAlarmInAndOut = {0};
	tAlarmInAndOut.iBuffSize = sizeof(AlarmInAndOut);
	tAlarmInAndOut.iType = iType;
	tAlarmInAndOut.iPortNo = iPortNo;
	tAlarmInAndOut.iPara1 = iPara1;
	tAlarmInAndOut.iPara2 = iPara2;

	int iRet = pClsNVD->procDEC_ClientSetDevConfig(iID, 0, 0, CMD_DEC_CFG_ALARM_IN_OUT, &tAlarmInAndOut, sizeof(AlarmInAndOut));
	if(iRet == 0)
		cout<<"[DEC_ClientSetDevConfig][CMD_DEC_CFG_ALARM_IN_OUT] ok"<<endl;
	else
		cout<<"[DEC_ClientSetDevConfig][CMD_DEC_CFG_ALARM_IN_OUT] fail!"<<iRet<<endl;

	return 0;
}

int GetAlarmInAndOut()
{
	SafeGetInt();

	int iID = -1;
	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();

	int iType = 0;
	cout<<"iType(0ߵ͵ƽã1ߵ͵ƽã2˿ʹܣ3˿ʹ):"<<endl;
	//cin>>iType;
	iType = SafeGetInt();

	int iPortNo = 0;
	cout<<"iPortNo(˿ں0-15):"<<endl;
	//cin>>iPortNo;
	iPortNo = SafeGetInt();

	AlarmInAndOut tAlarmInAndOut = {0};
	tAlarmInAndOut.iBuffSize = sizeof(AlarmInAndOut);
	tAlarmInAndOut.iType = iType;
	tAlarmInAndOut.iPortNo = iPortNo;
	int iRet = pClsNVD->procDEC_ClientGetDevConfig(iID, 0, 0, CMD_DEC_CFG_ALARM_IN_OUT, &tAlarmInAndOut, sizeof(AlarmInAndOut));
	if(iRet == 0)
	{
		cout<<"iType:"<<tAlarmInAndOut.iType<<endl;
		cout<<"iPortNo:"<<tAlarmInAndOut.iPortNo<<endl;
		cout<<"iPara1:"<<tAlarmInAndOut.iPara1<<endl;
		cout<<"iPara2:"<<tAlarmInAndOut.iPara2<<endl;
	}
	else
		cout<<"[DEC_ClientSetDevConfig][CMD_DEC_CFG_ALARM_IN_OUT] fail!"<<iRet<<endl;

	return 0;
}

int GetAlarmNotify()
{
	SafeGetInt();
	int iID = -1;
	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();

	int iChannelNo = 0;
	cout<<"iChannelNo(Χ0-15:"<<endl;
	iChannelNo = SafeGetInt();

	int iAlarmType = 0;
	cout<<"iAlarmType(128Ƶʧ129˿ڱ130ƶ⣻135ض˿ڱ):"<<endl;
	//cin>>iAlarmType;
	iAlarmType = SafeGetInt();

	AlarmNotify tAlarmNotify = {0};
	tAlarmNotify.iBuffSize = sizeof(AlarmNotify);
	tAlarmNotify.iAlarmType = iAlarmType;
	tAlarmNotify.iChannelNo = iChannelNo;
	int iRet = pClsNVD->procDEC_ClientGetDevConfig(iID, 0, 0, CMD_DEC_CFG_ALARM_NOTIFY, &tAlarmNotify, sizeof(AlarmNotify));
	if(iRet == 0)
	{
		cout<<"iAlarmType:"<<tAlarmNotify.iAlarmType<<endl;
		cout<<"iChannelNo:"<<tAlarmNotify.iChannelNo<<endl;
		cout<<"iState:"<<tAlarmNotify.iState<<endl;
	}
	else
		cout<<"[DEC_ClientSetDevConfig][CMD_DEC_CFG_ALARM_NOTIFY] fail!"<<iRet<<endl;

	return 0;
}

int SetScheduleEnable()
{
	SafeGetInt();

	int iID = -1;
	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();

	int iChannelNo = 0;
	cout<<"iChannelNo(Χ0-15:"<<endl;
	//cin>>iChannelNo;
	iChannelNo = SafeGetInt();

	int iAlarmType = 0;
	cout<<"iAlarmType(128Ƶʧ129˿ڱ130ƶ⣻135ض˿ڱ):"<<endl;
	//cin>>iAlarmType;
	iAlarmType = SafeGetInt();

	int iEnable = 0;
	cout<<"ʹiEnable(0ʹ 1ʹ):"<<endl;
	//cin>>iEnable;
	iEnable = SafeGetInt();

	int iParam1 = 0;
	cout<<"iParam1:"<<endl;
	//cin>>iParam1;
	iParam1 = SafeGetInt();

	int iParam2 = 0;
	cout<<"iParam2:"<<endl;
	//cin>>iParam2;
	iParam2 = SafeGetInt();

	int iParam3 = 0;
	cout<<"iParam3:"<<endl;
	//cin>>iParam3;
	iParam3 = SafeGetInt();

	ScheduleEnable tScheduleEnable = {0};
	tScheduleEnable.iBuffSize = sizeof(ScheduleEnable);
	tScheduleEnable.iChannelNo = iChannelNo;
	tScheduleEnable.iAlarmType = iAlarmType;
	tScheduleEnable.iEnable = iEnable;
	tScheduleEnable.iParam1 = iParam1;
	tScheduleEnable.iParam2 = iParam2;
	tScheduleEnable.iParam3 = iParam3;
	int iRet = pClsNVD->procDEC_ClientSetDevConfig(iID, 0, 0, CMD_DEC_CFG_SCHEDULE_ENABLE, &tScheduleEnable, sizeof(ScheduleEnable));
	if(iRet == 0)
		cout<<"[DEC_ClientSetDevConfig][CMD_DEC_CFG_SCHEDULE_ENABLE] ok"<<endl;
	else
		cout<<"[DEC_ClientSetDevConfig][CMD_DEC_CFG_SCHEDULE_ENABLE] fail!"<<iRet<<endl;

	return 0;
}

int GetScheduleEnable()
{
	SafeGetInt();

	int iID = -1;
	cout<<"Please specify decorder id:"<<endl;
	//cin>>iID;
	iID = SafeGetInt();

	int iChannelNo = 0;
	cout<<"iChannelNo(Χ0-15:"<<endl;
	//cin>>iChannelNo;
	iChannelNo = SafeGetInt();

	int iAlarmType = 0;
	cout<<"iAlarmType(128Ƶʧ129˿ڱ130ƶ⣻135ض˿ڱ):"<<endl;
	//cin>>iAlarmType;
	iAlarmType = SafeGetInt();

	ScheduleEnable tScheduleEnable = {0};
	tScheduleEnable.iBuffSize = sizeof(ScheduleEnable);
	tScheduleEnable.iChannelNo = iChannelNo;
	tScheduleEnable.iAlarmType = iAlarmType;
	int iRet = pClsNVD->procDEC_ClientGetDevConfig(iID, 0, 0, CMD_DEC_CFG_SCHEDULE_ENABLE, &tScheduleEnable, sizeof(ScheduleEnable));
	if(iRet == 0)
	{
		cout<<"iChannelNo:"<<tScheduleEnable.iChannelNo<<endl;
		cout<<"iAlarmType:"<<tScheduleEnable.iAlarmType<<endl;
		cout<<"iEnable:"<<tScheduleEnable.iEnable<<endl;
		cout<<"iParam1:"<<tScheduleEnable.iParam1<<endl;
		cout<<"iParam2:"<<tScheduleEnable.iParam2<<endl;
		cout<<"iParam3:"<<tScheduleEnable.iParam3<<endl;
	}
	else
		cout<<"[DEC_ClientSetDevConfig][CMD_DEC_CFG_SCHEDULE_ENABLE] fail!"<<iRet<<endl;

	return 0;
}

int SelectPicture()
{
	SafeGetInt();

	int iID = -1;
	int iChannel = -1;
	int iPos = -1;

	cout<<"Please specify decorder id:"<<endl;
	iID = SafeGetInt();
	cout<<"Channel:"<<endl;
	iChannel = SafeGetInt();
	cout<<"Picture no."<<endl;
	iPos = SafeGetInt();

	int iRet = pClsNVD->procDEC_SetSelectPicture(iID, iChannel, iPos);
	if(iRet == 0)
		cout<<"[DEC_SetSelectPicture]Set ok"<<endl;
	else
		cout<<"[DEC_SetSelectPicture]Set fail!"<<iRet<<endl;

	return 0;
}



